/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integrationtests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jbpm.integrationtests.JbpmSerializationHelper;
import org.jbpm.integrationtests.handler.TestWorkItemHandler;
import org.jbpm.integrationtests.test.Person;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.definition.KiePackage;
import org.kie.api.io.ResourceType;
import org.kie.api.marshalling.Marshaller;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.marshalling.MarshallerFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessMarshallingTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ProcessMarshallingTest.class);

    @Test
    public void testMarshallingProcessInstancesAndGlobals() throws Exception {
        String rule = "package org.test;\n";
        rule = rule + "import org.jbpm.integrationtests.test.Person\n";
        rule = rule + "global java.util.List list\n";
        rule = rule + "rule \"Rule 1\"\n";
        rule = rule + "  ruleflow-group \"hello\"\n";
        rule = rule + "when\n";
        rule = rule + "    $p : Person( ) \n";
        rule = rule + "then\n";
        rule = rule + "    list.add( $p );\n";
        rule = rule + "end";
        String process = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n    type=\"RuleFlow\" name=\"ruleflow\" id=\"org.test.ruleflow\" package-name=\"org.test\" >\n  <header>\n  </header>\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <ruleSet id=\"2\" name=\"Hello\" ruleFlowGroup=\"hello\" />\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n  <connections>\n    <connection from=\"1\" to=\"2\"/>\n    <connection from=\"2\" to=\"3\"/>\n  </connections>\n</process>";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(rule)), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(process)), ResourceType.DRF);
        KieSession ksession = this.createKieSession(kbuilder.getKnowledgePackages().toArray(new KiePackage[0]));
        ksession.getEnvironment().set("org.jbpm.rule.task.waitstate", (Object)true);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p = new Person("bobba fet", 32);
        ksession.insert((Object)p);
        ksession.startProcess("org.test.ruleflow");
        Assert.assertEquals((long)1L, (long)ksession.getProcessInstances().size());
        ksession = JbpmSerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        Assert.assertEquals((long)1L, (long)ksession.getProcessInstances().size());
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)((List)ksession.getGlobal("list")).size());
        Assert.assertEquals((Object)p, ((List)ksession.getGlobal("list")).get(0));
        Assert.assertEquals((long)0L, (long)ksession.getProcessInstances().size());
    }

    @Test
    public void testMarshallingProcessInstanceWithWorkItem() throws Exception {
        String process = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n    type=\"RuleFlow\" name=\"ruleflow\" id=\"org.test.ruleflow\" package-name=\"org.test\" >\n  <header>\n    <variables>\n      <variable name=\"myVariable\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        <value>OldValue</value>\n      </variable>\n    </variables>\n  </header>\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <workItem id=\"2\" name=\"Email\" >\n      <work name=\"Email\" >\n        <parameter name=\"Subject\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>Mail</value>\n        </parameter>\n        <parameter name=\"Text\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>This is an email</value>\n        </parameter>\n        <parameter name=\"To\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>you@mail.com</value>\n        </parameter>\n        <parameter name=\"From\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>me@mail.com</value>\n        </parameter>\n      </work>\n    </workItem>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n  <connections>\n    <connection from=\"1\" to=\"2\"/>\n    <connection from=\"2\" to=\"3\"/>\n  </connections>\n</process>";
        this.builder.addProcessFromXml((Reader)new StringReader(process));
        KieSession session = this.createKieSession((KiePackage[])this.builder.getPackages());
        TestWorkItemHandler handler = new TestWorkItemHandler();
        session.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)handler);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("myVariable", "ThisIsMyValue");
        session.startProcess("org.test.ruleflow", variables);
        Assert.assertEquals((long)1L, (long)session.getProcessInstances().size());
        Assert.assertTrue((handler.getWorkItem() != null ? 1 : 0) != 0);
        session = JbpmSerializationHelper.getSerialisedStatefulKnowledgeSession(session);
        Assert.assertEquals((long)1L, (long)session.getProcessInstances().size());
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)((ProcessInstance)session.getProcessInstances().iterator().next()).getContextInstance("VariableScope");
        Assert.assertEquals((Object)"ThisIsMyValue", (Object)variableScopeInstance.getVariable("myVariable"));
        session.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        Assert.assertEquals((long)0L, (long)session.getProcessInstances().size());
    }

    @Test
    public void testMarshallingWithHumanTaskAndRule() throws Exception {
        String process1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n  xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n  type=\"RuleFlow\" name=\"ruleflow\" id=\"com.sample.ruleflow\" package-name=\"com.sample\" >\n\n  <header>\n    <imports>\n      <import name=\"org.jbpm.integrationtests.test.Person\" />\n    </imports>\n    <swimlanes>\n      <swimlane name=\"swimlane\" />\n    </swimlanes>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <end id=\"4\" name=\"End\" />\n    <split id=\"5\" name=\"AND\" type=\"1\" />\n    <subProcess id=\"6\" name=\"SubProcess\" processId=\"com.sample.subflow\" />\n    <actionNode id=\"7\" name=\"Action\" >\n      <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Executing action 1\");</action>\n\t </actionNode>\n    <join id=\"8\" name=\"AND\" type=\"1\" />\n    <actionNode id=\"9\" name=\"Action\" >\n      <action type=\"expression\" dialect=\"mvel\" >System.out.println(\"Executing action 2\");</action>\n    </actionNode>\n    <ruleSet id=\"10\" name=\"RuleSet\" ruleFlowGroup=\"flowgroup\" />\n    <milestone id=\"11\" name=\"Event Wait\" >\n      <constraint type=\"rule\" dialect=\"mvel\" >Person( )</constraint>\n    </milestone>\n    <workItem id=\"12\" name=\"Log\" >\n      <work name=\"Log\" >\n        <parameter name=\"Message\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>This is a log message</value>\n        </parameter>\n      </work>\n    </workItem>\n    <composite id=\"13\" name=\"CompositeNode\" >\n      <variables>\n        <variable name=\"x\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>x-value</value>\n        </variable>\n      </variables>\n      <nodes>\n        <humanTask id=\"1\" name=\"Human Task\" swimlane=\"swimlane\" >\n          <work name=\"Human Task\" >\n            <parameter name=\"ActorId\" >\n              <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n              <value>John Doe</value>\n            </parameter>\n            <parameter name=\"Priority\" >\n              <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n            </parameter>\n            <parameter name=\"TaskName\" >\n              <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n              <value>Do something !</value>\n            </parameter>\n            <parameter name=\"Comment\" >\n              <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n            </parameter>\n          </work>\n        </humanTask>\n        <humanTask id=\"2\" name=\"Human Task\" swimlane=\"swimlane\" >\n          <work name=\"Human Task\" >\n            <parameter name=\"ActorId\" >\n              <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n            </parameter>\n            <parameter name=\"Priority\" >\n              <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n            </parameter>\n            <parameter name=\"TaskName\" >\n              <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n              <value>Do something else !</value>\n            </parameter>\n            <parameter name=\"Comment\" >\n              <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n            </parameter>\n          </work>\n          <mapping type=\"in\" from=\"x\" to=\"Priority\" />\n        </humanTask>\n      </nodes>\n      <connections>\n        <connection from=\"1\" to=\"2\" />\n      </connections>\n      <in-ports>\n        <in-port type=\"DROOLS_DEFAULT\" nodeId=\"1\" nodeInType=\"DROOLS_DEFAULT\" />\n      </in-ports>\n      <out-ports>\n        <out-port type=\"DROOLS_DEFAULT\" nodeId=\"2\" nodeOutType=\"DROOLS_DEFAULT\" />\n      </out-ports>\n    </composite>\n  </nodes>\n\n  <connections>\n    <connection from=\"9\" to=\"4\" />\n    <connection from=\"1\" to=\"5\" />\n    <connection from=\"5\" to=\"6\" />\n    <connection from=\"5\" to=\"7\" />\n    <connection from=\"7\" to=\"8\" />\n    <connection from=\"6\" to=\"8\" />\n    <connection from=\"10\" to=\"8\" />\n    <connection from=\"11\" to=\"8\" />\n    <connection from=\"12\" to=\"8\" />\n    <connection from=\"13\" to=\"8\" />\n    <connection from=\"8\" to=\"9\" />\n    <connection from=\"5\" to=\"10\" />\n    <connection from=\"5\" to=\"11\" />\n    <connection from=\"5\" to=\"12\" />\n    <connection from=\"5\" to=\"13\" />\n  </connections>\n\n</process>\n";
        this.builder.addProcessFromXml((Reader)new StringReader(process1));
        String process2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"com.sample.subflow\" package-name=\"com.sample\" >\n\n  <header>\n    <imports>\n      <import name=\"org.jbpm.integrationtests.test.Person\" />\n    </imports>\n  </header>\n\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <milestone id=\"2\" name=\"Event Wait\" >\n      <constraint type=\"rule\" dialect=\"mvel\" >Person( )</constraint>\n    </milestone>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n\n  <connections>\n    <connection from=\"1\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n  </connections>\n\n</process>\n";
        this.builder.addProcessFromXml((Reader)new StringReader(process2));
        String rule = "package com.sample\nimport org.jbpm.integrationtests.test.Person;\nrule \"Hello\" ruleflow-group \"flowgroup\"\n    when\n    then\n        System.out.println( \"Hello\" );\nend";
        this.builder.addPackageFromDrl((Reader)new StringReader(rule));
        KieSession session = this.createKieSession((KiePackage[])this.builder.getPackages());
        TestWorkItemHandler handler1 = new TestWorkItemHandler();
        session.getWorkItemManager().registerWorkItemHandler("Log", (WorkItemHandler)handler1);
        TestWorkItemHandler handler2 = new TestWorkItemHandler();
        session.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler2);
        session.startProcess("com.sample.ruleflow");
        Assert.assertEquals((long)2L, (long)session.getProcessInstances().size());
        Assert.assertTrue((handler1.getWorkItem() != null ? 1 : 0) != 0);
        long workItemId = handler2.getWorkItem().getId();
        Assert.assertTrue((workItemId != -1L ? 1 : 0) != 0);
        session = JbpmSerializationHelper.getSerialisedStatefulKnowledgeSession(session);
        session.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler2);
        Assert.assertEquals((long)2L, (long)session.getProcessInstances().size());
        handler2.reset();
        session.getWorkItemManager().completeWorkItem(workItemId, null);
        Assert.assertTrue((handler2.getWorkItem() != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"John Doe", (Object)handler2.getWorkItem().getParameter("SwimlaneActorId"));
        Assert.assertEquals((Object)"x-value", (Object)handler2.getWorkItem().getParameter("Priority"));
        session.getWorkItemManager().completeWorkItem(handler1.getWorkItem().getId(), null);
        session.getWorkItemManager().completeWorkItem(handler2.getWorkItem().getId(), null);
        session.insert((Object)new Person());
        session.fireAllRules();
        Assert.assertEquals((long)0L, (long)session.getProcessInstances().size());
    }

    @Test
    public void testMarshallingWithMultipleHumanTasks() throws Exception {
        String process = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n  xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n  type=\"RuleFlow\" name=\"ruleflow\" id=\"com.sample.ruleflow\" package-name=\"com.sample\" >\n\n    <header>\n      <variables>\n        <variable name=\"list\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.ObjectDataType\" className=\"java.util.List\" />\n        </variable>\n      </variables>\n    </header>\n\n    <nodes>\n      <forEach id=\"4\" name=\"ForEach\" variableName=\"item\" collectionExpression=\"list\" >\n        <nodes>\n          <humanTask id=\"1\" name=\"Human Task\" >\n            <work name=\"Human Task\" >\n              <parameter name=\"Comment\" >\n                <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n              </parameter>\n              <parameter name=\"ActorId\" >\n                <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n              </parameter>\n              <parameter name=\"Priority\" >\n                <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n              </parameter>\n              <parameter name=\"TaskName\" >\n                <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n                <value>Do something: #{item}</value>\n              </parameter>\n            </work>\n          </humanTask>\n          <humanTask id=\"2\" name=\"Human Task Again\" >\n            <work name=\"Human Task\" >\n              <parameter name=\"Comment\" >\n                <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n              </parameter>\n              <parameter name=\"ActorId\" >\n                <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n              </parameter>\n              <parameter name=\"Priority\" >\n                <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n              </parameter>\n              <parameter name=\"TaskName\" >\n                <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n                <value>Do something else: #{item}</value>\n              </parameter>\n            </work>\n          </humanTask>\n        </nodes>\n        <connections>\n          <connection from=\"1\" to=\"2\" />\n        </connections>\n        <in-ports>\n          <in-port type=\"DROOLS_DEFAULT\" nodeId=\"1\" nodeInType=\"DROOLS_DEFAULT\" />\n        </in-ports>\n        <out-ports>\n          <out-port type=\"DROOLS_DEFAULT\" nodeId=\"2\" nodeOutType=\"DROOLS_DEFAULT\" />\n        </out-ports>\n      </forEach>\n      <start id=\"1\" name=\"Start\" />\n      <end id=\"3\" name=\"End\" />\n    </nodes>\n\n    <connections>\n      <connection from=\"1\" to=\"4\" />\n      <connection from=\"4\" to=\"3\" />\n    </connections>\n\n</process>\n";
        this.builder.addProcessFromXml((Reader)new StringReader(process));
        KieSession session = this.createKieSession((KiePackage[])this.builder.getPackages());
        TestListWorkItemHandler handler = new TestListWorkItemHandler();
        session.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        list.add("three");
        HashMap<String, ArrayList<String>> parameters = new HashMap<String, ArrayList<String>>();
        parameters.put("list", list);
        session.startProcess("com.sample.ruleflow", parameters);
        Assert.assertEquals((long)1L, (long)session.getProcessInstances().size());
        Assert.assertEquals((long)3L, (long)handler.getWorkItems().size());
        ArrayList<WorkItem> workItems = new ArrayList<WorkItem>(handler.getWorkItems());
        handler.reset();
        for (WorkItem workItem : workItems) {
            session.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        }
        Assert.assertEquals((long)1L, (long)session.getProcessInstances().size());
        Assert.assertEquals((long)3L, (long)handler.getWorkItems().size());
        session = JbpmSerializationHelper.getSerialisedStatefulKnowledgeSession(session);
        for (WorkItem workItem : handler.getWorkItems()) {
            session.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        }
        Assert.assertEquals((long)0L, (long)session.getProcessInstances().size());
    }

    @Test
    @Ignore
    public void testMarshallingProcessInstanceWithTimer() throws Exception {
        String process = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n  xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n  type=\"RuleFlow\" name=\"ruleflow\" id=\"com.sample.ruleflow\" package-name=\"com.sample\" >\n\n    <header>\n    </header>\n\n    <nodes>\n      <start id=\"1\" name=\"Start\" />\n      <timerNode id=\"4\" name=\"Timer\" delay=\"200\" />\n      <end id=\"3\" name=\"End\" />\n    </nodes>\n\n    <connections>\n      <connection from=\"1\" to=\"4\" />\n      <connection from=\"4\" to=\"3\" />\n    </connections>\n\n</process>\n";
        this.builder.addProcessFromXml((Reader)new StringReader(process));
        KieSession session = this.createKieSession((KiePackage[])this.builder.getPackages());
        session.startProcess("com.sample.ruleflow");
        Assert.assertEquals((long)1L, (long)session.getProcessInstances().size());
        session.halt();
        StatefulKnowledgeSession session2 = JbpmSerializationHelper.getSerialisedStatefulKnowledgeSession(session);
        int procInstsAlive = session2.getProcessInstances().size();
        for (int sleeps = 3; procInstsAlive > 0 && sleeps > 0; --sleeps) {
            Thread.sleep(1000L);
            procInstsAlive = session2.getProcessInstances().size();
        }
        Assert.assertEquals((long)0L, (long)session2.getProcessInstances().size());
        session2.halt();
    }

    @Test
    public void testTimerOnUnmarshalledSession() throws Exception {
        String process = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n  xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n  type=\"RuleFlow\" name=\"ruleflow\" id=\"com.sample.ruleflow\" package-name=\"com.sample\" >\n\n    <header>\n    </header>\n\n    <nodes>\n      <start id=\"1\" name=\"Start\" />\n      <timerNode id=\"4\" name=\"Timer\" delay=\"1000\" />\n      <end id=\"3\" name=\"End\" />\n    </nodes>\n\n    <connections>\n      <connection from=\"1\" to=\"4\" />\n      <connection from=\"4\" to=\"3\" />\n    </connections>\n\n</process>\n";
        this.builder.addProcessFromXml((Reader)new StringReader(process));
        KieSession session = this.createKieSession((KiePackage[])this.builder.getPackages());
        session.startProcess("com.sample.ruleflow");
        Marshaller marshaller = MarshallerFactory.newMarshaller((KieBase)session.getKieBase());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        marshaller.marshall((OutputStream)baos, session);
        byte[] b1 = baos.toByteArray();
        baos.close();
        Assert.assertEquals((long)1L, (long)session.getProcessInstances().size());
        session.dispose();
        ByteArrayInputStream bais = new ByteArrayInputStream(b1);
        StatefulKnowledgeSession session2 = (StatefulKnowledgeSession)marshaller.unmarshall((InputStream)bais);
        int procInstsAlive = session2.getProcessInstances().size();
        for (int sleeps = 3; procInstsAlive > 0 && sleeps > 0; --sleeps) {
            Thread.yield();
            Thread.sleep(1000L);
            procInstsAlive = session2.getProcessInstances().size();
        }
        Assert.assertEquals((long)0L, (long)session2.getProcessInstances().size());
    }

    @Test
    public void testVariablePersistenceMarshallingStrategies() throws Exception {
        String process = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n    type=\"RuleFlow\" name=\"ruleflow\" id=\"org.test.ruleflow\" package-name=\"org.test\" >\n  <header>\n    <variables>\n      <variable name=\"myVariable\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n        <value>OldValue</value>\n      </variable>\n      <variable name=\"myPerson\" >\n        <type name=\"org.jbpm.process.core.datatype.impl.type.ObjectDataType\" className=\"org.jbpm.integrationtests.test.Person\"/>\n      </variable>\n    </variables>\n  </header>\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <workItem id=\"2\" name=\"Email\" >\n      <work name=\"Report\" >\n        <parameter name=\"Subject\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>Mail</value>\n        </parameter>\n        <parameter name=\"Subject\" >\n          <type name=\"org.jbpm.process.core.datatype.impl.type.StringDataType\" />\n          <value>Mail</value>\n        </parameter>\n      </work>\n    </workItem>\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n  <connections>\n    <connection from=\"1\" to=\"2\"/>\n    <connection from=\"2\" to=\"3\"/>\n  </connections>\n</process>";
        this.builder.addProcessFromXml((Reader)new StringReader(process));
        KieSession session = this.createKieSession((KiePackage[])this.builder.getPackages());
        TestWorkItemHandler handler = new TestWorkItemHandler();
        session.getWorkItemManager().registerWorkItemHandler("Report", (WorkItemHandler)handler);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("myVariable", "ThisIsMyValue");
        Person myPerson = new Person("Nikola Tesla", 156);
        variables.put("myPerson", myPerson);
        session.startProcess("org.test.ruleflow", variables);
        Assert.assertEquals((long)1L, (long)session.getProcessInstances().size());
        Assert.assertTrue((handler.getWorkItem() != null ? 1 : 0) != 0);
        session = JbpmSerializationHelper.getSerialisedStatefulKnowledgeSession(session);
        Assert.assertEquals((long)1L, (long)session.getProcessInstances().size());
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)((ProcessInstance)session.getProcessInstances().iterator().next()).getContextInstance("VariableScope");
        Assert.assertEquals((Object)"ThisIsMyValue", (Object)variableScopeInstance.getVariable("myVariable"));
        Assert.assertEquals((Object)myPerson, (Object)variableScopeInstance.getVariable("myPerson"));
        session.getWorkItemManager().completeWorkItem(handler.getWorkItem().getId(), null);
        Assert.assertEquals((long)0L, (long)session.getProcessInstances().size());
    }

    private static class TestListWorkItemHandler
    implements WorkItemHandler {
        private List<WorkItem> workItems = new ArrayList<WorkItem>();

        private TestListWorkItemHandler() {
        }

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            logger.debug("Executing workItem {}", workItem.getParameter("TaskName"));
            this.workItems.add(workItem);
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItems.remove(workItem);
        }

        public List<WorkItem> getWorkItems() {
            return this.workItems;
        }

        public void reset() {
            this.workItems.clear();
        }
    }
}

