/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.compiler.canonical;

import org.jbpm.compiler.canonical.ModelMetaData;
import org.jbpm.compiler.canonical.ProcessMetaData;
import org.jbpm.compiler.canonical.ProcessToExecModelGenerator;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.definition.process.WorkflowProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessToExecModelGeneratorTest {
    private static final Logger logger = LoggerFactory.getLogger(ProcessToExecModelGeneratorTest.class);

    @Test
    public void testScriptAndWorkItemGeneration() {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"demo.orders");
        factory.variable("order", (DataType)new ObjectDataType("com.myspace.demo.Order")).variable("approver", (DataType)new ObjectDataType("String")).name("orders").packageName("com.myspace.demo").dynamic(false).version("1.0").workItemNode(1L).name("Log").workName("Log").done().actionNode(2L).name("Dump order").action("java", "System.out.println(\"Order has been created \" + order);").done().endNode(3L).name("end").terminate(false).done().startNode(4L).name("start").done().connection(2L, 1L).connection(4L, 2L).connection(1L, 3L);
        RuleFlowProcess process = factory.validate().getProcess();
        ProcessMetaData processMetadata = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process);
        Assert.assertNotNull((String)"Dumper should return non null class for process", (Object)processMetadata);
        logger.debug(processMetadata.getGeneratedClassModel().toString());
        Assert.assertEquals((Object)"orders", (Object)processMetadata.getExtractedProcessId());
        Assert.assertEquals((Object)"demo.orders", (Object)processMetadata.getProcessId());
        Assert.assertEquals((Object)"orders", (Object)processMetadata.getProcessName());
        Assert.assertEquals((Object)"1.0", (Object)processMetadata.getProcessVersion());
        Assert.assertEquals((Object)"com.myspace.demo.OrdersProcess", (Object)processMetadata.getProcessClassName());
        Assert.assertNotNull((Object)processMetadata.getGeneratedClassModel());
        Assert.assertEquals((long)1L, (long)processMetadata.getWorkItems().size());
    }

    @Test
    public void testScriptAndWorkItemModelGeneration() {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"demo.orders");
        factory.variable("order", (DataType)new ObjectDataType("com.myspace.demo.Order")).variable("approver", (DataType)new ObjectDataType("String")).name("orders").packageName("com.myspace.demo").dynamic(false).version("1.0").workItemNode(1L).name("Log").workName("Log").done().actionNode(2L).name("Dump order").action("java", "System.out.println(\"Order has been created \" + order);").done().endNode(3L).name("end").terminate(false).done().startNode(4L).name("start").done().connection(2L, 1L).connection(4L, 2L).connection(1L, 3L);
        RuleFlowProcess process = factory.validate().getProcess();
        ModelMetaData modelMetadata = ProcessToExecModelGenerator.INSTANCE.generateModel((WorkflowProcess)process);
        Assert.assertNotNull((String)"Dumper should return non null class for process", (Object)modelMetadata);
        logger.info(modelMetadata.generate());
        Assert.assertEquals((Object)"com.myspace.demo.OrdersModel", (Object)modelMetadata.getModelClassName());
    }
}

