/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.event.process;

import java.util.ArrayList;
import org.apache.commons.lang3.mutable.MutableLong;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.EventTrigger;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.Trigger;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.api.runtime.process.ProcessInstance;
import org.slf4j.LoggerFactory;

public class ProcessEventSupportTest
extends AbstractBaseTest {
    @Override
    public void addLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testProcessEventListener() throws Exception {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("org.drools.test");
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process.event");
        process.setName("Event Process");
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        process.addNode((Node)startNode);
        ActionNode actionNode = new ActionNode();
        actionNode.setName("Print");
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", (Object)new Action(){

            public void execute(ProcessContext context) throws Exception {
                ProcessEventSupportTest.this.logger.info("Executed action");
            }
        });
        actionNode.setAction((DroolsAction)action);
        actionNode.setId(2L);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        EndNode endNode = new EndNode();
        endNode.setName("End");
        endNode.setId(3L);
        process.addNode((Node)endNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        pkg.addProcess((Process)process);
        ArrayList<KnowledgePackageImpl> pkgs = new ArrayList<KnowledgePackageImpl>();
        pkgs.add(pkg);
        kbase.addPackages(pkgs);
        KieSession session = kbase.newKieSession();
        final ArrayList processEventList = new ArrayList();
        ProcessEventListener processEventListener = new ProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                processEventList.add(event);
            }

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                processEventList.add(event);
            }

            public void afterProcessCompleted(ProcessCompletedEvent event) {
                processEventList.add(event);
            }

            public void afterProcessStarted(ProcessStartedEvent event) {
                processEventList.add(event);
            }

            public void beforeNodeLeft(ProcessNodeLeftEvent event) {
                processEventList.add(event);
            }

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                processEventList.add(event);
            }

            public void beforeProcessCompleted(ProcessCompletedEvent event) {
                processEventList.add(event);
            }

            public void beforeProcessStarted(ProcessStartedEvent event) {
                processEventList.add(event);
            }

            public void beforeVariableChanged(ProcessVariableChangedEvent event) {
                processEventList.add(event);
            }

            public void afterVariableChanged(ProcessVariableChangedEvent event) {
                processEventList.add(event);
            }
        };
        session.addEventListener(processEventListener);
        session.startProcess("org.drools.core.process.event");
        Assert.assertEquals((long)16L, (long)processEventList.size());
        Assert.assertEquals((Object)"org.drools.core.process.event", (Object)((ProcessStartedEvent)processEventList.get(0)).getProcessInstance().getProcessId());
        Assert.assertEquals((Object)"Start", (Object)((ProcessNodeTriggeredEvent)processEventList.get(1)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Start", (Object)((ProcessNodeLeftEvent)processEventList.get(2)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Print", (Object)((ProcessNodeTriggeredEvent)processEventList.get(3)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Print", (Object)((ProcessNodeLeftEvent)processEventList.get(4)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"End", (Object)((ProcessNodeTriggeredEvent)processEventList.get(5)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"End", (Object)((ProcessNodeLeftEvent)processEventList.get(6)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"org.drools.core.process.event", (Object)((ProcessCompletedEvent)processEventList.get(7)).getProcessInstance().getProcessId());
        Assert.assertEquals((Object)"org.drools.core.process.event", (Object)((ProcessCompletedEvent)processEventList.get(8)).getProcessInstance().getProcessId());
        Assert.assertEquals((Object)"End", (Object)((ProcessNodeLeftEvent)processEventList.get(9)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"End", (Object)((ProcessNodeTriggeredEvent)processEventList.get(10)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Print", (Object)((ProcessNodeLeftEvent)processEventList.get(11)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Print", (Object)((ProcessNodeTriggeredEvent)processEventList.get(12)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Start", (Object)((ProcessNodeLeftEvent)processEventList.get(13)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Start", (Object)((ProcessNodeTriggeredEvent)processEventList.get(14)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"org.drools.core.process.event", (Object)((ProcessStartedEvent)processEventList.get(15)).getProcessInstance().getProcessId());
    }

    @Test
    public void testProcessEventListenerWithEvent() throws Exception {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("org.drools.test");
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process.event");
        process.setName("Event Process");
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        process.addNode((Node)startNode);
        ActionNode actionNode = new ActionNode();
        actionNode.setName("Print");
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", (Object)new Action(){

            public void execute(ProcessContext context) throws Exception {
                ProcessEventSupportTest.this.logger.info("Executed action");
            }
        });
        actionNode.setAction((DroolsAction)action);
        actionNode.setId(2L);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        EventNode eventNode = new EventNode();
        eventNode.setName("Event");
        eventNode.setId(3L);
        ArrayList<EventTypeFilter> filters = new ArrayList<EventTypeFilter>();
        EventTypeFilter filter = new EventTypeFilter();
        filter.setType("signal");
        filters.add(filter);
        eventNode.setEventFilters(filters);
        process.addNode((Node)eventNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)eventNode, "DROOLS_DEFAULT");
        EndNode endNode = new EndNode();
        endNode.setName("End");
        endNode.setId(4L);
        process.addNode((Node)endNode);
        new ConnectionImpl((Node)eventNode, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        pkg.addProcess((Process)process);
        ArrayList<KnowledgePackageImpl> pkgs = new ArrayList<KnowledgePackageImpl>();
        pkgs.add(pkg);
        kbase.addPackages(pkgs);
        KieSession session = kbase.newKieSession();
        final ArrayList processEventList = new ArrayList();
        ProcessEventListener processEventListener = new ProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                processEventList.add(event);
            }

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                processEventList.add(event);
            }

            public void afterProcessCompleted(ProcessCompletedEvent event) {
                processEventList.add(event);
            }

            public void afterProcessStarted(ProcessStartedEvent event) {
                processEventList.add(event);
            }

            public void beforeNodeLeft(ProcessNodeLeftEvent event) {
                processEventList.add(event);
            }

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                processEventList.add(event);
            }

            public void beforeProcessCompleted(ProcessCompletedEvent event) {
                processEventList.add(event);
            }

            public void beforeProcessStarted(ProcessStartedEvent event) {
                processEventList.add(event);
            }

            public void beforeVariableChanged(ProcessVariableChangedEvent event) {
                processEventList.add(event);
            }

            public void afterVariableChanged(ProcessVariableChangedEvent event) {
                processEventList.add(event);
            }
        };
        session.addEventListener(processEventListener);
        ProcessInstance pi = session.startProcess("org.drools.core.process.event");
        pi.signalEvent("signal", null);
        Assert.assertEquals((long)20L, (long)processEventList.size());
        Assert.assertEquals((Object)"org.drools.core.process.event", (Object)((ProcessStartedEvent)processEventList.get(0)).getProcessInstance().getProcessId());
        Assert.assertEquals((Object)"Start", (Object)((ProcessNodeTriggeredEvent)processEventList.get(1)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Start", (Object)((ProcessNodeLeftEvent)processEventList.get(2)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Print", (Object)((ProcessNodeTriggeredEvent)processEventList.get(3)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Print", (Object)((ProcessNodeLeftEvent)processEventList.get(4)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Event", (Object)((ProcessNodeTriggeredEvent)processEventList.get(5)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Event", (Object)((ProcessNodeTriggeredEvent)processEventList.get(6)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Print", (Object)((ProcessNodeLeftEvent)processEventList.get(7)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Print", (Object)((ProcessNodeTriggeredEvent)processEventList.get(8)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Start", (Object)((ProcessNodeLeftEvent)processEventList.get(9)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Start", (Object)((ProcessNodeTriggeredEvent)processEventList.get(10)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"org.drools.core.process.event", (Object)((ProcessStartedEvent)processEventList.get(11)).getProcessInstance().getProcessId());
        Assert.assertEquals((Object)"Event", (Object)((ProcessNodeLeftEvent)processEventList.get(12)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"End", (Object)((ProcessNodeTriggeredEvent)processEventList.get(13)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"End", (Object)((ProcessNodeLeftEvent)processEventList.get(14)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"org.drools.core.process.event", (Object)((ProcessCompletedEvent)processEventList.get(15)).getProcessInstance().getProcessId());
        Assert.assertEquals((Object)"org.drools.core.process.event", (Object)((ProcessCompletedEvent)processEventList.get(16)).getProcessInstance().getProcessId());
        Assert.assertEquals((Object)"End", (Object)((ProcessNodeLeftEvent)processEventList.get(17)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Event", (Object)((ProcessNodeLeftEvent)processEventList.get(19)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"End", (Object)((ProcessNodeTriggeredEvent)processEventList.get(18)).getNodeInstance().getNodeName());
    }

    @Test
    public void testProcessEventListenerWithEndEvent() throws Exception {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("org.drools.test");
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process.event");
        process.setName("Event Process");
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        process.addNode((Node)startNode);
        ActionNode actionNode = new ActionNode();
        actionNode.setName("Print");
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", (Object)new Action(){

            public void execute(ProcessContext context) throws Exception {
                ProcessEventSupportTest.this.logger.info("Executed action");
            }
        });
        actionNode.setAction((DroolsAction)action);
        actionNode.setId(2L);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        EndNode endNode = new EndNode();
        endNode.setName("End");
        endNode.setId(3L);
        endNode.setTerminate(false);
        process.addNode((Node)endNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        pkg.addProcess((Process)process);
        ArrayList<KnowledgePackageImpl> pkgs = new ArrayList<KnowledgePackageImpl>();
        pkgs.add(pkg);
        kbase.addPackages(pkgs);
        KieSession session = kbase.newKieSession();
        final ArrayList processEventList = new ArrayList();
        ProcessEventListener processEventListener = new ProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                processEventList.add(event);
            }

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                processEventList.add(event);
            }

            public void afterProcessCompleted(ProcessCompletedEvent event) {
                processEventList.add(event);
            }

            public void afterProcessStarted(ProcessStartedEvent event) {
                processEventList.add(event);
            }

            public void beforeNodeLeft(ProcessNodeLeftEvent event) {
                processEventList.add(event);
            }

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                processEventList.add(event);
            }

            public void beforeProcessCompleted(ProcessCompletedEvent event) {
                processEventList.add(event);
            }

            public void beforeProcessStarted(ProcessStartedEvent event) {
                processEventList.add(event);
            }

            public void beforeVariableChanged(ProcessVariableChangedEvent event) {
                processEventList.add(event);
            }

            public void afterVariableChanged(ProcessVariableChangedEvent event) {
                processEventList.add(event);
            }
        };
        session.addEventListener(processEventListener);
        session.startProcess("org.drools.core.process.event");
        Assert.assertEquals((long)14L, (long)processEventList.size());
        Assert.assertEquals((Object)"org.drools.core.process.event", (Object)((ProcessStartedEvent)processEventList.get(0)).getProcessInstance().getProcessId());
        Assert.assertEquals((Object)"Start", (Object)((ProcessNodeTriggeredEvent)processEventList.get(1)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Start", (Object)((ProcessNodeLeftEvent)processEventList.get(2)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Print", (Object)((ProcessNodeTriggeredEvent)processEventList.get(3)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Print", (Object)((ProcessNodeLeftEvent)processEventList.get(4)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"End", (Object)((ProcessNodeTriggeredEvent)processEventList.get(5)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"End", (Object)((ProcessNodeLeftEvent)processEventList.get(6)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"End", (Object)((ProcessNodeLeftEvent)processEventList.get(7)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"End", (Object)((ProcessNodeTriggeredEvent)processEventList.get(8)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Print", (Object)((ProcessNodeLeftEvent)processEventList.get(9)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Print", (Object)((ProcessNodeTriggeredEvent)processEventList.get(10)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Start", (Object)((ProcessNodeLeftEvent)processEventList.get(11)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Start", (Object)((ProcessNodeTriggeredEvent)processEventList.get(12)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"org.drools.core.process.event", (Object)((ProcessStartedEvent)processEventList.get(13)).getProcessInstance().getProcessId());
    }

    @Test
    public void testProcessEventListenerWithStartEvent() throws Exception {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("org.drools.test");
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process.event");
        process.setName("Event Process");
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        EventTrigger trigger = new EventTrigger();
        EventTypeFilter eventFilter = new EventTypeFilter();
        eventFilter.setType("signal");
        trigger.addEventFilter((EventFilter)eventFilter);
        startNode.addTrigger((Trigger)trigger);
        process.addNode((Node)startNode);
        ActionNode actionNode = new ActionNode();
        actionNode.setName("Print");
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", (Object)new Action(){

            public void execute(ProcessContext context) throws Exception {
                ProcessEventSupportTest.this.logger.info("Executed action");
            }
        });
        actionNode.setAction((DroolsAction)action);
        actionNode.setId(2L);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        EndNode endNode = new EndNode();
        endNode.setName("End");
        endNode.setId(3L);
        process.addNode((Node)endNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        pkg.addProcess((Process)process);
        ArrayList<KnowledgePackageImpl> pkgs = new ArrayList<KnowledgePackageImpl>();
        pkgs.add(pkg);
        kbase.addPackages(pkgs);
        KieSession session = kbase.newKieSession();
        final ArrayList processEventList = new ArrayList();
        ProcessEventListener processEventListener = new ProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                processEventList.add(event);
            }

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                processEventList.add(event);
            }

            public void afterProcessCompleted(ProcessCompletedEvent event) {
                processEventList.add(event);
            }

            public void afterProcessStarted(ProcessStartedEvent event) {
                processEventList.add(event);
            }

            public void beforeNodeLeft(ProcessNodeLeftEvent event) {
                processEventList.add(event);
            }

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                processEventList.add(event);
            }

            public void beforeProcessCompleted(ProcessCompletedEvent event) {
                processEventList.add(event);
            }

            public void beforeProcessStarted(ProcessStartedEvent event) {
                processEventList.add(event);
            }

            public void beforeVariableChanged(ProcessVariableChangedEvent event) {
                processEventList.add(event);
            }

            public void afterVariableChanged(ProcessVariableChangedEvent event) {
                processEventList.add(event);
            }
        };
        session.addEventListener(processEventListener);
        session.signalEvent("signal", null);
        Assert.assertEquals((long)16L, (long)processEventList.size());
        Assert.assertEquals((Object)"org.drools.core.process.event", (Object)((ProcessStartedEvent)processEventList.get(0)).getProcessInstance().getProcessId());
        Assert.assertEquals((Object)"Start", (Object)((ProcessNodeTriggeredEvent)processEventList.get(1)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Start", (Object)((ProcessNodeLeftEvent)processEventList.get(2)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Print", (Object)((ProcessNodeTriggeredEvent)processEventList.get(3)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Print", (Object)((ProcessNodeLeftEvent)processEventList.get(4)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"End", (Object)((ProcessNodeTriggeredEvent)processEventList.get(5)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"End", (Object)((ProcessNodeLeftEvent)processEventList.get(6)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"org.drools.core.process.event", (Object)((ProcessCompletedEvent)processEventList.get(7)).getProcessInstance().getProcessId());
        Assert.assertEquals((Object)"org.drools.core.process.event", (Object)((ProcessCompletedEvent)processEventList.get(8)).getProcessInstance().getProcessId());
        Assert.assertEquals((Object)"End", (Object)((ProcessNodeLeftEvent)processEventList.get(9)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"End", (Object)((ProcessNodeTriggeredEvent)processEventList.get(10)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Print", (Object)((ProcessNodeLeftEvent)processEventList.get(11)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Print", (Object)((ProcessNodeTriggeredEvent)processEventList.get(12)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Start", (Object)((ProcessNodeLeftEvent)processEventList.get(13)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"Start", (Object)((ProcessNodeTriggeredEvent)processEventList.get(14)).getNodeInstance().getNodeName());
        Assert.assertEquals((Object)"org.drools.core.process.event", (Object)((ProcessStartedEvent)processEventList.get(15)).getProcessInstance().getProcessId());
    }

    @Test
    public void testDefaultParentProcessIdValueInProcessEventListener() throws Exception {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process.event");
        process.setName("Event Process");
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        process.addNode((Node)startNode);
        EndNode endNode = new EndNode();
        endNode.setName("End");
        endNode.setId(3L);
        process.addNode((Node)endNode);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("org.drools.test");
        pkg.addProcess((Process)process);
        ArrayList<KnowledgePackageImpl> pkgs = new ArrayList<KnowledgePackageImpl>();
        pkgs.add(pkg);
        kbase.addPackages(pkgs);
        KieSession session = kbase.newKieSession();
        final MutableLong parentProcessId = new MutableLong(0L);
        DefaultProcessEventListener processEventListener = new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                parentProcessId.setValue(event.getProcessInstance().getParentProcessInstanceId());
            }
        };
        session.addEventListener((ProcessEventListener)processEventListener);
        session.startProcess("org.drools.core.process.event");
        Assert.assertEquals((long)parentProcessId.longValue(), (long)-1L);
    }
}

