/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.transformation;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.kie.api.runtime.process.DataTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScriptingDataTransformer
implements DataTransformer {
    private static final Logger logger = LoggerFactory.getLogger(JavaScriptingDataTransformer.class);
    private ScriptEngineFactory factory;
    private ScriptEngine scriptEngine;
    private Map<String, Object> engineProperties = new HashMap<String, Object>();

    public JavaScriptingDataTransformer(ScriptEngineFactory factory) {
        this.factory = factory;
        this.scriptEngine = this.factory.getScriptEngine();
        this.registerAttributes();
    }

    public Object transform(Object expression, Map<String, Object> parameters) {
        return this.evaluateExpression(expression, parameters);
    }

    public Object compile(String expression, Map<String, Object> parameters) {
        if (this.scriptEngine instanceof Compilable) {
            logger.debug("Compiling expression {} with engine {}", (Object)expression, (Object)this.scriptEngine);
            try {
                return ((Compilable)((Object)this.scriptEngine)).compile(expression);
            }
            catch (ScriptException e) {
                throw new RuntimeException("Error when compiling script", e);
            }
        }
        logger.debug("Compilation not supported on engine {}", (Object)this.scriptEngine);
        return expression;
    }

    protected Object evaluateExpression(Object expression, Map<String, Object> parameters) {
        try {
            Object result = null;
            StringWriter writer = new StringWriter();
            SimpleScriptContext context = new SimpleScriptContext();
            for (Map.Entry<String, Object> property : this.engineProperties.entrySet()) {
                context.setAttribute(property.getKey(), property.getValue(), 100);
            }
            Bindings bindings = context.getBindings(100);
            bindings.putAll((Map<? extends String, ? extends Object>)parameters);
            context.setBindings(bindings, 100);
            context.setWriter(writer);
            if (expression instanceof CompiledScript) {
                logger.debug("About to evaluate compiled expression {} with bindings {} on engine", new Object[]{expression, parameters, this.scriptEngine});
                result = ((CompiledScript)expression).eval(context);
            } else {
                logger.debug("About to evaluate expression {} with bindings {} on engine", new Object[]{expression, parameters, this.scriptEngine});
                result = this.scriptEngine.eval(expression.toString(), (ScriptContext)context);
            }
            if (result == null) {
                result = writer.toString();
            }
            return result;
        }
        catch (ScriptException e) {
            throw new RuntimeException("Error when evaluating script", e);
        }
    }

    protected void registerAttributes() {
        try {
            InputStream propsIn = this.getClass().getResourceAsStream("/" + this.factory.getClass().getName() + ".properties");
            if (propsIn != null) {
                Properties props = new Properties();
                props.load(propsIn);
                for (String propertyName : props.stringPropertyNames()) {
                    Object objectValue = this.resolveValue(props.getProperty(propertyName));
                    if (objectValue == null) continue;
                    this.engineProperties.put(propertyName, objectValue);
                }
            }
        }
        catch (IOException e) {
            logger.error("Error while loading script engine properties", (Throwable)e);
        }
    }

    private Object resolveValue(String value) {
        if (value == null) {
            return null;
        }
        if (value.toLowerCase().matches("true|false")) {
            return Boolean.parseBoolean(value);
        }
        if (value.matches("\\d+")) {
            return Integer.parseInt(value);
        }
        return value;
    }
}

