/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.util;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.util.WidMVELEvaluator;
import org.junit.Assert;
import org.junit.Test;
import org.mvel2.CompileException;
import org.slf4j.LoggerFactory;

public class WidMVELEvaluatorTest
extends AbstractBaseTest {
    @Override
    public void addLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testWidNoImports() throws Exception {
        this.assertCorrectWids(WidMVELEvaluator.eval((String)this.getResouceContent("/wids/test-noimports.wid")));
    }

    @Test
    public void testWidBackwardsCompatImports() throws Exception {
        this.assertCorrectWids(WidMVELEvaluator.eval((String)this.getResouceContent("/wids/test-backwardscompat.wid")));
    }

    @Test
    public void testWidBackwardsCompatPkgImports() throws Exception {
        this.assertCorrectWids(WidMVELEvaluator.eval((String)this.getResouceContent("/wids/test-backwardscompatpkgimport.wid")));
    }

    @Test
    public void testWidBackwardsCompatMixedAndMissingImports() throws Exception {
        this.assertCorrectWids(WidMVELEvaluator.eval((String)this.getResouceContent("/wids/test-backwardscompatmixedandmissingimports.wid")));
    }

    @Test
    public void testWidCustomDataType() throws Exception {
        this.assertCorrectWids(WidMVELEvaluator.eval((String)this.getResouceContent("/wids/test-customdatatype.wid")));
    }

    @Test
    public void testWidCustomDataTypeNoImport() {
        try {
            this.assertCorrectWids(WidMVELEvaluator.eval((String)this.getResouceContent("/wids/test-customdatatypenoimport.wid")));
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)(t instanceof CompileException));
        }
    }

    protected String getResouceContent(String path) throws Exception {
        return IOUtils.toString((InputStream)this.getClass().getResourceAsStream(path), (String)"UTF-8");
    }

    protected String getResouce(String path) throws Exception {
        return this.getClass().getResource(path).getFile();
    }

    private void assertCorrectWids(Object wids) {
        Assert.assertNotNull((Object)wids);
        List widsMap = (List)wids;
        Assert.assertEquals((long)2L, (long)widsMap.size());
        Map firstWid = (Map)widsMap.get(0);
        Assert.assertNotNull((Object)firstWid);
        Assert.assertEquals((Object)"MyFirstWorkItem", firstWid.get("name"));
        Map firstWidParams = (Map)firstWid.get("parameters");
        Assert.assertNotNull((Object)firstWidParams);
        Assert.assertEquals((long)6L, (long)firstWidParams.size());
        Map firstWidParamValues = (Map)firstWid.get("parameterValues");
        Assert.assertNotNull((Object)firstWidParamValues);
        Assert.assertEquals((long)1L, (long)firstWidParamValues.size());
        Map secondWid = (Map)widsMap.get(1);
        Assert.assertNotNull((Object)secondWid);
        Assert.assertEquals((Object)"MySecondWorkItem", secondWid.get("name"));
        Map secondWidParams = (Map)secondWid.get("parameters");
        Assert.assertNotNull((Object)secondWidParams);
        Assert.assertEquals((long)6L, (long)secondWidParams.size());
        Map secondWidParamValues = (Map)secondWid.get("parameterValues");
        Assert.assertNotNull((Object)secondWidParamValues);
        Assert.assertEquals((long)1L, (long)secondWidParamValues.size());
    }
}

