/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.timer.impl.quartz;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.jbpm.process.core.timer.impl.quartz.QuartzUtils;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;
import org.quartz.utils.Key;
import org.slf4j.Logger;

public class DeploymentsAwareStdJDBCDelegate
extends StdJDBCDelegate {
    private QuartzUtils quartzUtils = new QuartzUtils();

    public DeploymentsAwareStdJDBCDelegate(Logger logger, String tablePrefix, String instanceId, Boolean useProperties) {
        super(logger, tablePrefix, instanceId, useProperties);
    }

    public DeploymentsAwareStdJDBCDelegate(Logger logger, String tablePrefix, String instanceId) {
        super(logger, tablePrefix, instanceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List selectTriggerToAcquire(Connection conn, long noLaterThan, long noEarlierThan) throws SQLException {
        LinkedList<Key> linkedList;
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<Key> nextTriggers = new LinkedList<Key>();
        try {
            List<String> deploymentIds = this.quartzUtils.getDeployments();
            ps = conn.prepareStatement(this.rtp(this.quartzUtils.nextTriggerQuery(deploymentIds)));
            ps.setFetchSize(5);
            ps.setMaxRows(5);
            ps.setString(1, "WAITING");
            ps.setBigDecimal(2, new BigDecimal(String.valueOf(noLaterThan)));
            ps.setBigDecimal(3, new BigDecimal(String.valueOf(noEarlierThan)));
            int index = 4;
            for (String deployment : deploymentIds) {
                ps.setString(index++, deployment);
            }
            rs = ps.executeQuery();
            while (rs.next() && nextTriggers.size() < 5) {
                nextTriggers.add(new Key(rs.getString("TRIGGER_NAME"), rs.getString("TRIGGER_GROUP")));
            }
            linkedList = nextTriggers;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
        this.closeResultSet(rs);
        this.closeStatement(ps);
        return linkedList;
    }

    public int countMisfiredTriggersInStates(Connection conn, String state1, String state2, long ts) throws SQLException {
        block4: {
            int n;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                List<String> deploymentIds = this.quartzUtils.getDeployments();
                ps = conn.prepareStatement(this.rtp(this.quartzUtils.countMisfiredTriggersQuery(deploymentIds)));
                ps.setBigDecimal(1, new BigDecimal(String.valueOf(ts)));
                ps.setString(2, state1);
                ps.setString(3, state2);
                int index = 4;
                for (String deployment : deploymentIds) {
                    ps.setString(index++, deployment);
                }
                rs = ps.executeQuery();
                if (!rs.next()) break block4;
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(ps);
                throw throwable;
            }
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return n;
        }
        throw new SQLException("No misfired trigger count returned.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean selectMisfiredTriggersInStates(Connection conn, String state1, String state2, long ts, int count, List resultList) throws SQLException {
        boolean bl;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            List<String> deploymentIds = this.quartzUtils.getDeployments();
            ps = conn.prepareStatement(this.rtp(this.quartzUtils.misfiredTriggersQuery(deploymentIds)));
            ps.setBigDecimal(1, new BigDecimal(String.valueOf(ts)));
            ps.setString(2, state1);
            ps.setString(3, state2);
            int index = 4;
            for (String deployment : deploymentIds) {
                ps.setString(index++, deployment);
            }
            rs = ps.executeQuery();
            boolean hasReachedLimit = false;
            while (rs.next() && !hasReachedLimit) {
                if (resultList.size() == count) {
                    hasReachedLimit = true;
                    continue;
                }
                String triggerName = rs.getString("TRIGGER_NAME");
                String groupName = rs.getString("TRIGGER_GROUP");
                resultList.add(new Key(triggerName, groupName));
            }
            bl = hasReachedLimit;
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
        this.closeResultSet(rs);
        this.closeStatement(ps);
        return bl;
    }
}

