/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.timer;

import java.io.File;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.jbpm.process.core.timer.BusinessCalendarImpl;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.time.SessionClock;
import org.kie.api.time.SessionPseudoClock;
import org.slf4j.LoggerFactory;

public class BusinessCalendarImplTest
extends AbstractBaseTest {
    @Override
    public void addLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testCalculateHoursSimulatedSLASameDay() {
        Properties config = new Properties();
        config.setProperty("business.hours.per.day", "5");
        config.setProperty("business.start.hour", "17");
        config.setProperty("business.end.hour", "22");
        String currentDate = "2018-05-04 16:00:00";
        String expectedDate = "2018-05-04 21:00:00";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDateWithTime(currentDate).getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate("4h");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm:ss", result));
    }

    @Test
    public void testCalculateHoursSimulatedSLADifferentDay() {
        Properties config = new Properties();
        config.setProperty("business.hours.per.day", "5");
        config.setProperty("business.start.hour", "17");
        config.setProperty("business.end.hour", "22");
        String currentDate = "2018-05-03 21:00:00";
        String expectedDate = "2018-05-04 20:00:00";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDateWithTime(currentDate).getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate("4h");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm:ss", result));
    }

    @Test
    public void testCalculateHours() {
        Properties config = new Properties();
        String expectedDate = "2012-05-04 16:45";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDateWithTime("2012-05-04 13:45").getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate("3h");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm", result));
    }

    @Test
    public void testCalculateHoursCustomWorkingHours() {
        Properties config = new Properties();
        config.setProperty("business.start.hour", "13");
        config.setProperty("business.end.hour", "19");
        config.setProperty("business.hours.per.day", "6");
        String expectedDate = "2012-05-04 15:45";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDateWithTime("2012-05-03 13:45").getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate("8h");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm", result));
    }

    @Test
    public void testCalculateHoursPassingOverWeekend() {
        Properties config = new Properties();
        String expectedDate = "2012-05-07 12:45";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDateWithTime("2012-05-04 13:45").getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate("7h");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm", result));
    }

    @Test
    public void testCalculateHoursPassingOverCustomDefinedWeekend() {
        Properties config = new Properties();
        config.setProperty("business.weekend.days", "6,7");
        String expectedDate = "2012-05-06 12:45";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDateWithTime("2012-05-03 13:45").getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate("7h");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm", result));
    }

    @Test
    public void testCalculateMinutesPassingOverWeekend() {
        Properties config = new Properties();
        String expectedDate = "2012-05-07 09:15";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDateWithTime("2012-05-04 16:45").getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate("30m");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm", result));
    }

    @Test
    public void testCalculateMinutesPassingOverHoliday() {
        Properties config = new Properties();
        config.setProperty("business.holidays", "2012-05-12:2012-05-19");
        String expectedDate = "2012-05-21 09:15";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDateWithTime("2012-05-11 16:45").getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate("30m");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm", result));
    }

    @Test
    public void testCalculateDays() {
        Properties config = new Properties();
        String expectedDate = "2012-05-14 09:00";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDate("2012-05-04").getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate("6d");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm", result));
    }

    @Test
    public void testCalculateDaysStartingInWeekend() {
        Properties config = new Properties();
        String expectedDate = "2012-05-09 09:00";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDate("2012-05-05").getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate("2d");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm", result));
    }

    @Test
    public void testCalculateDaysCustomWorkingDays() {
        Properties config = new Properties();
        config.setProperty("business.days.per.week", "4");
        config.setProperty("business.weekend.days", "6,7,1");
        String expectedDate = "2012-05-15 14:30";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDateWithTime("2012-05-03 14:30").getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate("6d");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm", result));
    }

    @Test
    public void testCalculateDaysMiddleDay() {
        Properties config = new Properties();
        String expectedDate = "2012-05-11 12:27";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDateWithTime("2012-05-03 12:27").getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate("6d");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm", result));
    }

    @Test
    public void testCalculateDaysHoursMinutes() {
        Properties config = new Properties();
        String expectedDate = "2012-05-14 14:20";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDate("2012-05-04").getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate("6d4h80m");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm", result));
    }

    @Test
    public void testCalculateTimeDaysHoursMinutesHolidays() {
        Properties config = new Properties();
        config.setProperty("business.holidays", "2012-05-10:2012-05-19");
        String expectedDate = "2012-05-23 14:20";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDate("2012-05-04").getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate("6d4h80m");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm", result));
    }

    @Test
    public void testCalculateHoursSimulatedSLAHolidaysAndWeekend() {
        Properties config = new Properties();
        config.setProperty("business.holidays", "2020-12-18");
        config.setProperty("business.start.hour", "8");
        config.setProperty("business.end.hour", "17");
        config.setProperty("business.hours.per.day", "9");
        String expectedDate = "2020-12-22 09:39:57";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDateWithTimeAndSeconds("2020-12-16 13:09:57").getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate("23h30m");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm:ss", result));
    }

    @Test
    public void testCalculateHoursSimulatedSLAHolidaysTodayAndWeekend() {
        Properties config = new Properties();
        config.setProperty("business.holidays", "2020-12-16");
        config.setProperty("business.start.hour", "8");
        config.setProperty("business.end.hour", "17");
        config.setProperty("business.hours.per.day", "9");
        String expectedDate = "2020-12-21 13:30";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDateWithTimeAndSeconds("2020-12-16 15:13:50").getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate("23h30m");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm", result));
    }

    @Test
    public void testCalculateHoursSimulatedSLAHolidaysTodayAndWeekendTomorrow() {
        Properties config = new Properties();
        config.setProperty("business.holidays", "2020-12-18");
        config.setProperty("business.start.hour", "8");
        config.setProperty("business.end.hour", "17");
        config.setProperty("business.hours.per.day", "9");
        String expectedDate = "2020-12-23 13:30";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDateWithTimeAndSeconds("2020-12-18 15:13:50").getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate("23h30m");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm", result));
    }

    @Test
    public void testCalculateHoursSimulatedSLAHolidaysNotConsecutive() {
        Properties config = new Properties();
        config.setProperty("business.holidays", "2020-12-22");
        config.setProperty("business.start.hour", "8");
        config.setProperty("business.end.hour", "17");
        config.setProperty("business.hours.per.day", "9");
        String expectedDate = "2020-12-24 13:30";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDateWithTimeAndSeconds("2020-12-19 15:13:50").getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate("23h30m");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm", result));
    }

    @Test
    public void testCalculateTimeDaysHoursMinutesSingleDayHolidays() {
        Properties config = new Properties();
        config.setProperty("business.holidays", "2012-05-07");
        String expectedDate = "2012-05-08 13:20";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDate("2012-05-04").getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate("1d4h20m");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm", result));
    }

    @Test
    public void testCalculateTimeDaysHoursMinutesSingleDayHolidaysInMiddleOfWeek() {
        Properties config = new Properties();
        config.setProperty("business.holidays", "2012-05-09");
        String expectedDate = "2012-05-10 15:30";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDateWithTime("2012-05-08 11:10").getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate("1d4h20m");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm", result));
    }

    @Test
    public void testCalculateDaysPassingOverHolidayAtYearEnd() {
        Properties config = new Properties();
        config.setProperty("business.holidays", "2012-12-31:2013-01-01");
        String expectedDate = "2013-01-04 09:15";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDateWithTime("2012-12-28 16:45").getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate("2d30m");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm", result));
    }

    @Test
    public void testCalculateDaysPassingOverHolidayAtYearEndWithWildcards() {
        Properties config = new Properties();
        config.setProperty("business.holidays", "*-12-31:*-01-01");
        String expectedDate = "2013-01-02 09:15";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDateWithTime("2012-12-28 16:45").getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate("2d30m");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm", result));
    }

    @Test
    public void testCalculateISOHours() {
        Properties config = new Properties();
        String expectedDate = "2012-05-04 16:45";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDateWithTime("2012-05-04 13:45").getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate("PT3H");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm", result));
    }

    @Test
    public void testCalculateISODaysAndHours() {
        Properties config = new Properties();
        config.setProperty("business.holidays", "2012-05-09");
        String expectedDate = "2012-05-10 15:30";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDateWithTime("2012-05-08 11:10").getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate("P1DT4H20M");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm", result));
    }

    @Test
    public void testSingleHolidayWithinGivenTime() {
        Properties props = new Properties();
        props.put("business.holidays", "2015-01-13");
        String expectedDate = "2015-01-15 11:38";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDateWithTimeAndMillis("2015-01-08 11:38:30.198").getTime());
        BusinessCalendarImpl businessCalendarImpl = new BusinessCalendarImpl(props, (SessionClock)clock);
        Date result = businessCalendarImpl.calculateBusinessTimeAsDate("4d");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm", result));
    }

    @Test
    public void testCalculateMillisecondsAsDefault() {
        Properties config = new Properties();
        String expectedDate = "2012-05-04 16:45:10.000";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDateWithTimeAndMillis("2012-05-04 16:45:00.000").getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate("10000");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm:ss.SSS", result));
    }

    @Test
    public void testCalculateMinutesPassingAfterHour() {
        Properties config = new Properties();
        String currentDate = "2018-05-02 19:51:33";
        String expectedDate = "2018-05-03 09:01:00";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDateWithTime(currentDate).getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate("1m");
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm:ss", result));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMissingConfigurationDualArgConstructor() {
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDateWithTime("2012-05-04 13:45").getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(null, (SessionClock)clock);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMissingConfigurationSingleArgConstructor() {
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl((Properties)null);
    }

    @Test
    public void testCalculateMinutesPassingHoliday() {
        Properties config = new Properties();
        config.setProperty("business.days.per.week", "5");
        config.setProperty("business.hours.per.day", "8");
        config.setProperty("business.start.hour", "9");
        config.setProperty("business.end.hour", "18");
        config.setProperty("business.weekend.days", "1,7");
        config.setProperty("business.holidays", "2018-04-30,2018-05-03:2018-05-05");
        config.setProperty("business.holiday.date.format", "yyyy-MM-dd");
        String currentDate = "2018-05-03 13:51:33";
        String duration = "10m";
        String expectedDate = "2018-05-07 09:10:00";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDateWithTime(currentDate).getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate(duration);
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm:ss", result));
    }

    @Test
    public void testCalculateMinutesPassingWeekend() {
        Properties config = new Properties();
        String currentDate = "2018-05-06 13:51:33";
        String duration = "10m";
        String expectedDate = "2018-05-07 09:10:00";
        StaticPseudoClock clock = new StaticPseudoClock(this.parseToDateWithTime(currentDate).getTime());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(config, (SessionClock)clock);
        Date result = businessCal.calculateBusinessTimeAsDate(duration);
        Assert.assertEquals((Object)expectedDate, (Object)this.formatDate("yyyy-MM-dd HH:mm:ss", result));
    }

    @Test
    public void testLoadGoodInputStream() throws Exception {
        URL url = this.getClass().getResource("/business-custom-calendar.properties");
        File file = new File(url.toURI());
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl(file.getAbsolutePath());
        int myCustomProperty = businessCal.getPropertyAsInt("MyCustomProperty", "3");
        Assert.assertEquals((long)7L, (long)myCustomProperty);
    }

    @Test
    public void testLoadBadInputStream() {
        BusinessCalendarImpl businessCal = new BusinessCalendarImpl("/bad-uri.properties");
        int myCustomProperty = businessCal.getPropertyAsInt("MyCustomProperty", "3");
        Assert.assertEquals((long)3L, (long)myCustomProperty);
    }

    private Date parseToDate(String dateString) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date testTime = sdf.parse(dateString);
            return testTime;
        }
        catch (ParseException e) {
            return null;
        }
    }

    private Date parseToDateWithTime(String dateString) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        try {
            Date testTime = sdf.parse(dateString);
            return testTime;
        }
        catch (ParseException e) {
            return null;
        }
    }

    private Date parseToDateWithTimeAndSeconds(String dateString) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date testTime = sdf.parse(dateString);
            return testTime;
        }
        catch (ParseException e) {
            return null;
        }
    }

    private Date parseToDateWithTimeAndMillis(String dateString) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        try {
            Date testTime = sdf.parse(dateString);
            return testTime;
        }
        catch (ParseException e) {
            return null;
        }
    }

    private String formatDate(String pattern, Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String testTime = sdf.format(date);
        return testTime;
    }

    private class StaticPseudoClock
    implements SessionPseudoClock {
        private long currentTime;

        private StaticPseudoClock(long currenttime) {
            this.currentTime = currenttime;
        }

        public long getCurrentTime() {
            return this.currentTime;
        }

        public long advanceTime(long amount, TimeUnit unit) {
            throw new UnsupportedOperationException("It is static clock and does not allow advance time operation");
        }
    }
}

