/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process;

import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.runtime.process.ProcessRuntimeFactory;
import org.drools.core.runtime.process.ProcessRuntimeFactoryService;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.ProcessRuntimeFactoryServiceImpl;
import org.jbpm.process.instance.timer.TimerInstance;
import org.jbpm.process.instance.timer.TimerManager;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.slf4j.LoggerFactory;

public class TimerTest
extends AbstractBaseTest {
    private int counter = 0;

    @Override
    public void addLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    @Ignore
    public void testTimer() {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        final KieSession workingMemory = kbase.newKieSession();
        RuleFlowProcessInstance processInstance = new RuleFlowProcessInstance(){
            private static final long serialVersionUID = 510L;

            public void signalEvent(String type, Object event) {
                if ("timerTriggered".equals(type)) {
                    TimerInstance timer = (TimerInstance)event;
                    TimerTest.this.logger.info("Timer {} triggered", (Object)timer.getId());
                    TimerTest.this.counter++;
                }
            }
        };
        processInstance.setKnowledgeRuntime(((InternalWorkingMemory)workingMemory).getKnowledgeRuntime());
        processInstance.setId(1234L);
        InternalProcessRuntime processRuntime = (InternalProcessRuntime)((InternalWorkingMemory)workingMemory).getProcessRuntime();
        processRuntime.getProcessInstanceManager().internalAddProcessInstance((org.kie.api.runtime.process.ProcessInstance)processInstance);
        new Thread(new Runnable(){

            @Override
            public void run() {
                workingMemory.fireUntilHalt();
            }
        }).start();
        TimerManager timerManager = ((InternalProcessRuntime)((InternalWorkingMemory)workingMemory).getProcessRuntime()).getTimerManager();
        TimerInstance timer = new TimerInstance();
        timerManager.registerTimer(timer, (ProcessInstance)processInstance);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)this.counter);
        this.counter = 0;
        timer = new TimerInstance();
        timer.setDelay(500L);
        timerManager.registerTimer(timer, (ProcessInstance)processInstance);
        Assert.assertEquals((long)0L, (long)this.counter);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)this.counter);
        this.counter = 0;
        timer = new TimerInstance();
        timer.setDelay(500L);
        timer.setPeriod(300L);
        timerManager.registerTimer(timer, (ProcessInstance)processInstance);
        Assert.assertEquals((long)0L, (long)this.counter);
        try {
            Thread.sleep(700L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)this.counter);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((this.counter >= 4 ? 1 : 0) != 0);
        timerManager.cancelTimer(1234L, timer.getId());
        int lastCount = this.counter;
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)lastCount, (long)this.counter);
    }

    static {
        ProcessRuntimeFactory.setProcessRuntimeFactoryService((ProcessRuntimeFactoryService)new ProcessRuntimeFactoryServiceImpl());
    }
}

