/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import org.jbpm.process.core.impl.ObjectCloner;
import org.junit.Assert;
import org.junit.Test;

public class ObjectClonerTest {
    @Test
    public void testInmutable() {
        ObjectCloner.Config config = new ObjectCloner.Config().deepCloneCollections(false);
        Object obj = 5;
        Assert.assertSame((Object)obj, (Object)ObjectCloner.clone((Object)obj));
        obj = true;
        Assert.assertSame((Object)obj, (Object)ObjectCloner.clone((Object)obj));
        obj = "pepe";
        Assert.assertSame((Object)obj, (Object)ObjectCloner.clone((Object)obj));
        obj = Arrays.asList("1", "2", "3");
        Assert.assertSame(obj, (Object)ObjectCloner.clone(obj, (ObjectCloner.Config)config));
        obj = Collections.singletonMap("pepe", "forever");
        Assert.assertSame((Object)obj, (Object)ObjectCloner.clone((Object)obj, (ObjectCloner.Config)config));
        obj = null;
        Assert.assertSame((Object)obj, (Object)ObjectCloner.clone((Object)obj));
    }

    @Test
    public void testMutablePOJOWithDefaultConstructor() {
        Person person = new Person();
        person.setAddress(new Address("Rue del Percebe", 13));
        person.setStatus(Status.MARRIED);
        person.setAge(101);
        Object cloned = ObjectCloner.clone((Object)person);
        Assert.assertNotSame((Object)person, (Object)cloned);
        Assert.assertEquals((Object)person, (Object)cloned);
    }

    @Test
    public void testPrimitiveArray() {
        int[] object = new int[]{2, 3, 5, 7, 11, 13, 17};
        int[] cloned = (int[])ObjectCloner.clone((Object)object);
        Assert.assertNotSame((Object)object, (Object)cloned);
        Assert.assertArrayEquals((int[])object, (int[])cloned);
    }

    @Test
    public void testObjectArray() {
        Object[] object = new Object[]{new NamedPerson("pepe"), new Room("id", false)};
        Object[] cloned = (Object[])ObjectCloner.clone((Object)object);
        Assert.assertNotSame((Object)object, (Object)cloned);
        Assert.assertArrayEquals((Object[])object, (Object[])cloned);
    }

    @Test
    public void testCollection() {
        ArrayList<Object> object = new ArrayList<Object>();
        object.add(new NamedPerson("pepe"));
        object.add(new Room("pepe", false));
        Object cloned = ObjectCloner.clone(object);
        Assert.assertNotSame(object, (Object)cloned);
        Assert.assertEquals(object, (Object)cloned);
    }

    @Test
    public void testMap() {
        HashMap<String, Object> object = new HashMap<String, Object>();
        object.put("person", new NamedPerson("pepe"));
        object.put("room", new Room("pepe", false));
        Object cloned = ObjectCloner.clone(object);
        Assert.assertNotSame(object, (Object)cloned);
        Assert.assertEquals(object, (Object)cloned);
    }

    @Test
    public void testCloneable() {
        Picture object = new Picture("javierito", new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        Object cloned = ObjectCloner.clone((Object)object);
        Assert.assertNotSame((Object)object, (Object)cloned);
        Assert.assertEquals((Object)object, (Object)cloned);
    }

    @Test
    public void testMutablePOJOWithConstructor() {
        NamedPerson person = new NamedPerson("pepe");
        person.setAddress(new Address("Rue del Percebe", 13));
        person.setStatus(Status.SINGLE);
        person.setAge(23);
        Object cloned = ObjectCloner.clone((Object)person);
        Assert.assertNotSame((Object)person, (Object)cloned);
        Assert.assertEquals((Object)person, (Object)cloned);
    }

    @Test
    public void testMutablePOJOWithCopyConstructor() {
        Room room = new Room();
        room.setId("Aloha");
        room.setOpen(true);
        Object cloned = ObjectCloner.clone((Object)room);
        Assert.assertNotSame((Object)room, (Object)cloned);
        Assert.assertEquals((Object)room, (Object)cloned);
    }

    @Test
    public void testPojoWithPublicFields() {
        BigBrother object = new BigBrother();
        object.name = "nosecomeunarosca";
        object.lovers = Collections.unmodifiableList(Collections.emptyList());
        Object cloned = ObjectCloner.clone((Object)object);
        Assert.assertNotSame((Object)object, (Object)cloned);
        Assert.assertEquals((Object)object, (Object)cloned);
    }

    @Test
    public void testInmutablePOJO() {
        Address address = new Address("Rue del Percebe", 13);
        Assert.assertSame((Object)address, (Object)ObjectCloner.clone((Object)address));
    }

    public static class BigBrother {
        public String name;
        public Collection<Person> lovers;

        public int hashCode() {
            return Objects.hash(this.lovers, this.name);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BigBrother)) {
                return false;
            }
            BigBrother other = (BigBrother)obj;
            return Objects.equals(this.lovers, other.lovers) && Objects.equals(this.name, other.name);
        }
    }

    public static class Picture
    implements Cloneable {
        private String author;
        private byte[] data;

        public Picture(String author, byte[] data) {
            this.author = author;
            this.data = data;
        }

        public Object clone() {
            return new Picture(this.author, this.data);
        }

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public byte[] getData() {
            return this.data;
        }

        public void setData(byte[] data) {
            this.data = data;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.data);
            result = 31 * result + Objects.hash(this.author);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Picture)) {
                return false;
            }
            Picture other = (Picture)obj;
            return Objects.equals(this.author, other.author) && Arrays.equals(this.data, other.data);
        }
    }

    public static class Address {
        private final String street;
        private final int number;

        public Address(String street, int number) {
            this.street = street;
            this.number = number;
        }

        public String getStreet() {
            return this.street;
        }

        public int getNumber() {
            return this.number;
        }

        public int hashCode() {
            return Objects.hash(this.number, this.street);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Address)) {
                return false;
            }
            Address other = (Address)obj;
            return this.number == other.number && Objects.equals(this.street, other.street);
        }
    }

    public static class Person {
        private Address address;
        private Status status;
        private int age;

        public Address getAddress() {
            return this.address;
        }

        public void setAddress(Address address) {
            this.address = address;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.address, this.age, this.status});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Person)) {
                return false;
            }
            Person other = (Person)obj;
            return Objects.equals(this.address, other.address) && this.age == other.age && this.status == other.status;
        }

        public String toString() {
            return "Person [address=" + this.address + ", status=" + (Object)((Object)this.status) + ", age=" + this.age + "]";
        }
    }

    public static class Room {
        private String id;
        private boolean open;

        public Room() {
        }

        public Room(Room room) {
            this.id = room.id;
            this.open = room.open;
        }

        public Room(String id, boolean open) {
            this.id = id;
            this.open = open;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean isOpen() {
            return this.open;
        }

        public void setOpen(boolean open) {
            this.open = open;
        }

        public String toString() {
            return "Room [id=" + this.id + ", open=" + this.open + "]";
        }

        public int hashCode() {
            return Objects.hash(this.id, this.open);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Room)) {
                return false;
            }
            Room other = (Room)obj;
            return Objects.equals(this.id, other.id) && this.open == other.open;
        }
    }

    public static class NamedPerson
    extends Person {
        private String name;

        public NamedPerson(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + Objects.hash(this.name);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof NamedPerson)) {
                return false;
            }
            NamedPerson other = (NamedPerson)obj;
            return Objects.equals(this.name, other.name);
        }
    }

    private static enum Status {
        SINGLE,
        MARRIED,
        DIVORCED,
        WIDOWED;

    }
}

