/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.util.MVELSafeHelper;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.impl.DataTransformerRegistry;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.ContextInstanceContainer;
import org.jbpm.process.instance.context.exception.ExceptionScopeInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.ContextInstanceFactory;
import org.jbpm.process.instance.impl.ContextInstanceFactoryRegistry;
import org.jbpm.process.instance.impl.util.VariableUtil;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.SubProcessFactory;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.Transformation;
import org.jbpm.workflow.instance.impl.NodeInstanceResolverFactory;
import org.jbpm.workflow.instance.impl.VariableScopeResolverFactory;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.DataTransformer;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationKeyFactory;
import org.kie.submarine.process.ProcessInstance;
import org.mvel2.integration.VariableResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LambdaSubProcessNodeInstance
extends StateBasedNodeInstance
implements EventListener,
ContextInstanceContainer {
    private static final long serialVersionUID = 510L;
    private static final Logger logger = LoggerFactory.getLogger(LambdaSubProcessNodeInstance.class);
    private Map<String, ContextInstance> contextInstances = new HashMap<String, ContextInstance>();
    private Map<String, List<ContextInstance>> subContextInstances = new HashMap<String, List<ContextInstance>>();
    private long processInstanceId;

    protected SubProcessNode getSubProcessNode() {
        return (SubProcessNode)this.getNode();
    }

    @Override
    public void internalTrigger(NodeInstance from, String type) {
        super.internalTrigger(from, type);
        if (this.getNodeInstanceContainer().getNodeInstance(this.getId()) == null) {
            return;
        }
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("A SubProcess node only accepts default incoming connections!");
        }
        String processId = this.getSubProcessNode().getProcessId();
        org.drools.core.spi.ProcessContext context = new org.drools.core.spi.ProcessContext((KieRuntime)this.getProcessInstance().getKnowledgeRuntime());
        context.setNodeInstance((NodeInstance)this);
        SubProcessFactory subProcessFactory = this.getSubProcessNode().getSubProcessFactory();
        Object o = subProcessFactory.bind((ProcessContext)context);
        ProcessInstance processInstance = subProcessFactory.createInstance(o);
        if (((WorkflowProcessInstanceImpl)this.getProcessInstance()).getCorrelationKey() != null) {
            ArrayList<String> businessKeys = new ArrayList<String>();
            businessKeys.add(((WorkflowProcessInstanceImpl)this.getProcessInstance()).getCorrelationKey());
            businessKeys.add(processId);
            businessKeys.add(String.valueOf(System.currentTimeMillis()));
            CorrelationKeyFactory correlationKeyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
            CorrelationKey subProcessCorrelationKey = correlationKeyFactory.newCorrelationKey(businessKeys);
            throw new UnsupportedOperationException("correlation key is unsupported");
        }
        processInstance.start();
        subProcessFactory.unbind((ProcessContext)context, processInstance.variables());
        if (!this.getSubProcessNode().isWaitForCompletion()) {
            this.triggerCompleted();
        } else if (processInstance.status() == 2 || processInstance.status() == 3) {
            this.triggerCompleted();
        } else {
            this.addProcessListener();
        }
    }

    private Map<String, Object> prepareParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (DataAssociation mapping : this.getSubProcessNode().getInAssociations()) {
            Object parameterValue = null;
            if (mapping.getTransformation() != null) {
                Transformation transformation = mapping.getTransformation();
                DataTransformer transformer = DataTransformerRegistry.get().find(transformation.getLanguage());
                if (transformer != null) {
                    parameterValue = transformer.transform(transformation.getCompiledExpression(), this.getSourceParameters(mapping));
                }
            } else {
                VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", mapping.getSources().get(0));
                if (variableScopeInstance != null) {
                    parameterValue = variableScopeInstance.getVariable(mapping.getSources().get(0));
                } else {
                    try {
                        parameterValue = MVELSafeHelper.getEvaluator().eval(mapping.getSources().get(0), (VariableResolverFactory)new NodeInstanceResolverFactory(this));
                    }
                    catch (Throwable t) {
                        parameterValue = VariableUtil.resolveVariable(mapping.getSources().get(0), this);
                        if (parameterValue != null) {
                            parameters.put(mapping.getTarget(), parameterValue);
                        }
                        logger.error("Could not find variable scope for variable {}", (Object)mapping.getSources().get(0));
                        logger.error("when trying to execute SubProcess node {}", (Object)this.getSubProcessNode().getName());
                        logger.error("Continuing without setting parameter.");
                    }
                }
            }
            if (parameterValue == null) continue;
            parameters.put(mapping.getTarget(), parameterValue);
        }
        return parameters;
    }

    private Process getProcess(String processId) {
        return null;
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.getSubProcessNode() == null || !this.getSubProcessNode().isIndependent()) {
            org.jbpm.process.instance.ProcessInstance processInstance = null;
            InternalKnowledgeRuntime kruntime = this.getProcessInstance().getKnowledgeRuntime();
            processInstance = (org.jbpm.process.instance.ProcessInstance)kruntime.getProcessInstance(this.processInstanceId);
            if (processInstance != null) {
                processInstance.setState(3);
            }
        }
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void internalSetProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public void addEventListeners() {
        super.addEventListeners();
        this.addProcessListener();
    }

    private void addProcessListener() {
        this.getProcessInstance().addEventListener("processInstanceCompleted:" + this.processInstanceId, this, true);
    }

    @Override
    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().removeEventListener("processInstanceCompleted:" + this.processInstanceId, this, true);
    }

    @Override
    public void signalEvent(String type, Object event) {
        if (("processInstanceCompleted:" + this.processInstanceId).equals(type)) {
            this.processInstanceCompleted((org.jbpm.process.instance.ProcessInstance)event);
        } else {
            super.signalEvent(type, event);
        }
    }

    @Override
    public String[] getEventTypes() {
        return new String[]{"processInstanceCompleted:" + this.processInstanceId};
    }

    public void processInstanceCompleted(org.jbpm.process.instance.ProcessInstance processInstance) {
        this.removeEventListeners();
        this.handleOutMappings(processInstance);
        if (processInstance.getState() == 3) {
            String faultName = processInstance.getOutcome() == null ? "" : processInstance.getOutcome();
            ExceptionScopeInstance exceptionScopeInstance = (ExceptionScopeInstance)this.resolveContextInstance("ExceptionScope", faultName);
            if (exceptionScopeInstance != null) {
                exceptionScopeInstance.handleException(faultName, processInstance.getFaultData());
                if (this.getSubProcessNode() != null && !this.getSubProcessNode().isIndependent() && this.getSubProcessNode().isAbortParent()) {
                    this.cancel();
                }
                return;
            }
            if (this.getSubProcessNode() != null && !this.getSubProcessNode().isIndependent() && this.getSubProcessNode().isAbortParent()) {
                this.getProcessInstance().setState(3, faultName);
                return;
            }
        }
        if (this.getNode() == null) {
            this.setMetaData("NodeType", "SubProcessNode");
        }
        this.triggerCompleted();
    }

    private void handleOutMappings(org.jbpm.process.instance.ProcessInstance processInstance) {
        VariableScopeInstance subProcessVariableScopeInstance = (VariableScopeInstance)processInstance.getContextInstance("VariableScope");
        SubProcessNode subProcessNode = this.getSubProcessNode();
        if (subProcessNode != null) {
            for (DataAssociation mapping : subProcessNode.getOutAssociations()) {
                if (mapping.getTransformation() != null) {
                    Transformation transformation = mapping.getTransformation();
                    DataTransformer transformer = DataTransformerRegistry.get().find(transformation.getLanguage());
                    if (transformer == null) continue;
                    Object parameterValue = transformer.transform(transformation.getCompiledExpression(), subProcessVariableScopeInstance.getVariables());
                    VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", mapping.getTarget());
                    if (variableScopeInstance != null && parameterValue != null) {
                        variableScopeInstance.setVariable(mapping.getTarget(), parameterValue);
                        continue;
                    }
                    logger.warn("Could not find variable scope for variable {}", (Object)mapping.getTarget());
                    logger.warn("Continuing without setting variable.");
                    continue;
                }
                VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", mapping.getTarget());
                if (variableScopeInstance != null) {
                    Object value = subProcessVariableScopeInstance.getVariable(mapping.getSources().get(0));
                    if (value == null) {
                        try {
                            value = MVELSafeHelper.getEvaluator().eval(mapping.getSources().get(0), (VariableResolverFactory)new VariableScopeResolverFactory(subProcessVariableScopeInstance));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    variableScopeInstance.setVariable(mapping.getTarget(), value);
                    continue;
                }
                logger.error("Could not find variable scope for variable {}", (Object)mapping.getTarget());
                logger.error("when trying to complete SubProcess node {}", (Object)this.getSubProcessNode().getName());
                logger.error("Continuing without setting variable.");
            }
        } else {
            this.mapDynamicOutputData(subProcessVariableScopeInstance.getVariables());
        }
    }

    @Override
    public String getNodeName() {
        Node node = this.getNode();
        if (node == null) {
            return "[Dynamic] Sub Process";
        }
        return super.getNodeName();
    }

    @Override
    public List<ContextInstance> getContextInstances(String contextId) {
        return this.subContextInstances.get(contextId);
    }

    @Override
    public void addContextInstance(String contextId, ContextInstance contextInstance) {
        List<ContextInstance> list = this.subContextInstances.get(contextId);
        if (list == null) {
            list = new ArrayList<ContextInstance>();
            this.subContextInstances.put(contextId, list);
        }
        list.add(contextInstance);
    }

    @Override
    public void removeContextInstance(String contextId, ContextInstance contextInstance) {
        List<ContextInstance> list = this.subContextInstances.get(contextId);
        if (list != null) {
            list.remove(contextInstance);
        }
    }

    @Override
    public ContextInstance getContextInstance(String contextId, long id) {
        List<ContextInstance> contextInstances = this.subContextInstances.get(contextId);
        if (contextInstances != null) {
            for (ContextInstance contextInstance : contextInstances) {
                if (contextInstance.getContextId() != id) continue;
                return contextInstance;
            }
        }
        return null;
    }

    @Override
    public ContextInstance getContextInstance(Context context) {
        ContextInstanceFactory conf = ContextInstanceFactoryRegistry.INSTANCE.getContextInstanceFactory(context);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal context type (registry not found): " + context.getClass());
        }
        ContextInstance contextInstance = conf.getContextInstance(context, this, this.getProcessInstance());
        if (contextInstance == null) {
            throw new IllegalArgumentException("Illegal context type (instance not found): " + context.getClass());
        }
        return contextInstance;
    }

    @Override
    public ContextContainer getContextContainer() {
        return this.getSubProcessNode();
    }

    protected Map<String, Object> getSourceParameters(DataAssociation association) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (String sourceParam : association.getSources()) {
            Object parameterValue = null;
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", sourceParam);
            if (variableScopeInstance != null) {
                parameterValue = variableScopeInstance.getVariable(sourceParam);
            } else {
                try {
                    parameterValue = MVELSafeHelper.getEvaluator().eval(sourceParam, (VariableResolverFactory)new NodeInstanceResolverFactory(this));
                }
                catch (Throwable t) {
                    logger.warn("Could not find variable scope for variable {}", (Object)sourceParam);
                }
            }
            if (parameterValue == null) continue;
            parameters.put(association.getTarget(), parameterValue);
        }
        return parameters;
    }
}

