/*
 * Decompiled with CFR 0.152.
 */
package org.kie.submarine.process.impl;

import java.util.Collections;
import org.jbpm.process.instance.LightProcessRuntime;
import org.jbpm.process.instance.LightProcessRuntimeContext;
import org.jbpm.process.instance.LightProcessRuntimeServiceProvider;
import org.jbpm.process.instance.ProcessRuntimeServiceProvider;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.submarine.Model;
import org.kie.submarine.process.Process;
import org.kie.submarine.process.ProcessConfig;
import org.kie.submarine.process.ProcessInstance;
import org.kie.submarine.process.Signal;
import org.kie.submarine.process.impl.ConfiguredProcessServices;
import org.kie.submarine.process.impl.MapProcessInstances;

public abstract class AbstractProcess<T extends Model>
implements Process<T> {
    private final MapProcessInstances<T> instances;
    private final ProcessRuntimeServiceProvider services;

    protected AbstractProcess(ProcessRuntimeServiceProvider services) {
        this.services = services;
        this.instances = new MapProcessInstances();
    }

    public T createModel() {
        return null;
    }

    public ProcessInstance<T> createInstance(Model m) {
        return this.createInstance(m);
    }

    protected AbstractProcess() {
        this(new LightProcessRuntimeServiceProvider());
    }

    protected AbstractProcess(ProcessConfig config) {
        this(new ConfiguredProcessServices(config));
    }

    public final MapProcessInstances<T> instances() {
        return this.instances;
    }

    public final <S> void send(Signal<S> signal) {
        this.instances().values().forEach(pi -> pi.send(signal));
    }

    protected abstract org.kie.api.definition.process.Process legacyProcess();

    protected ProcessRuntime createLegacyProcessRuntime() {
        return new LightProcessRuntime(new LightProcessRuntimeContext(Collections.singletonList(this.legacyProcess())), this.services);
    }
}

