/*
 * Decompiled with CFR 0.152.
 */
package org.kie.submarine.process.impl;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.api.runtime.process.WorkItemNotFoundException;
import org.kie.submarine.Model;
import org.kie.submarine.process.Process;
import org.kie.submarine.process.ProcessInstance;
import org.kie.submarine.process.Signal;
import org.kie.submarine.process.WorkItem;
import org.kie.submarine.process.impl.AbstractProcess;
import org.kie.submarine.process.impl.BaseWorkItem;

public abstract class AbstractProcessInstance<T extends Model>
implements ProcessInstance<T> {
    private final T variables;
    private final AbstractProcess<T> process;
    private final ProcessRuntime rt;
    private org.kie.api.runtime.process.ProcessInstance legacyProcessInstance;
    private int status;

    public AbstractProcessInstance(AbstractProcess<T> process, T variables, ProcessRuntime rt) {
        this.process = process;
        this.rt = rt;
        this.variables = variables;
    }

    public void start() {
        Map<String, Object> map = this.bind(this.variables);
        String id = this.process.legacyProcess().getId();
        this.legacyProcessInstance = this.rt.createProcessInstance(id, map);
        long pid = this.legacyProcessInstance.getId();
        this.process.instances().update(pid, this);
        org.kie.api.runtime.process.ProcessInstance pi = this.rt.startProcessInstance(pid);
        this.unbind(this.variables, pi.getVariables());
        this.status = pi.getState();
        this.removeOnFinish();
    }

    public void abort() {
        if (this.legacyProcessInstance == null) {
            return;
        }
        long pid = this.legacyProcessInstance.getId();
        this.unbind(this.variables, this.legacyProcessInstance.getVariables());
        this.process.instances().remove(pid);
        this.rt.abortProcessInstance(pid);
        this.status = this.legacyProcessInstance.getState();
    }

    public <S> void send(Signal<S> signal) {
        this.legacyProcessInstance.signalEvent(signal.channel(), signal.payload());
        this.status = this.legacyProcessInstance.getState();
        this.removeOnFinish();
    }

    public Process<T> process() {
        return this.process;
    }

    public T variables() {
        return this.variables;
    }

    public int status() {
        return this.status;
    }

    public long id() {
        return this.legacyProcessInstance.getId();
    }

    public WorkItem workItem(Long workItemId) {
        WorkItemNodeInstance workItemInstance = (WorkItemNodeInstance)((WorkflowProcessInstance)this.legacyProcessInstance).getNodeInstances().stream().filter(ni -> ni instanceof WorkItemNodeInstance && ((WorkItemNodeInstance)ni).getWorkItemId() == workItemId.longValue()).findFirst().orElseThrow(() -> new WorkItemNotFoundException("Work item with id " + workItemId + " was not found in process instance " + this.id(), workItemId));
        return new BaseWorkItem(workItemInstance.getWorkItem().getId(), workItemInstance.getWorkItem().getParameters().getOrDefault("TaskName", workItemInstance.getNodeName()), workItemInstance.getWorkItem().getParameters());
    }

    public List<WorkItem> workItems() {
        return ((WorkflowProcessInstance)this.legacyProcessInstance).getNodeInstances().stream().filter(ni -> ni instanceof WorkItemNodeInstance).map(ni -> new BaseWorkItem(((WorkItemNodeInstance)ni).getWorkItemId(), ((WorkItemNodeInstance)ni).getWorkItem().getParameters().getOrDefault("TaskName", ni.getNodeName()))).collect(Collectors.toList());
    }

    public void completeWorkItem(long id, Map<String, Object> variables) {
        this.rt.getWorkItemManager().completeWorkItem(id, variables);
        this.unbind(this.variables, this.legacyProcessInstance.getVariables());
        this.status = this.legacyProcessInstance.getState();
        this.removeOnFinish();
    }

    public void abortWorkItem(long id) {
        this.rt.getWorkItemManager().abortWorkItem(id);
        this.unbind(this.variables, this.legacyProcessInstance.getVariables());
        this.status = this.legacyProcessInstance.getState();
        this.removeOnFinish();
    }

    protected void removeOnFinish() {
        if (this.status != 1) {
            this.process.instances().remove(this.legacyProcessInstance.getId());
        }
    }

    protected Map<String, Object> bind(T variables) {
        HashMap<String, Object> vmap = new HashMap<String, Object>();
        if (variables == null) {
            return vmap;
        }
        try {
            for (Field f : variables.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                Object v = null;
                v = f.get(variables);
                vmap.put(f.getName(), v);
            }
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        vmap.put("$v", variables);
        return vmap;
    }

    protected void unbind(T variables, Map<String, Object> vmap) {
        try {
            for (Field f : variables.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                f.set(variables, vmap.get(f.getName()));
            }
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        vmap.put("$v", variables);
    }
}

