/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.tasks;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.jbpm.formapi.client.CommonGlobals;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.FormBuilderService;
import org.jbpm.formbuilder.client.messages.I18NConstants;
import org.jbpm.formbuilder.client.tasks.TaskRow;
import org.jbpm.formbuilder.shared.task.TaskPropertyRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickFormPanel
extends PopupPanel {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private final FormBuilderService server = FormBuilderGlobals.getInstance().getService();
    private final Button okButton = new Button(this.i18n.ConfirmButton());
    private final List<TaskPropertyRef> selectedInputs = new ArrayList();
    private final List<TaskPropertyRef> selectedOutputs = new ArrayList();

    public QuickFormPanel(TaskRow row) {
        VerticalPanel vPanel = new VerticalPanel();
        List inputs = row.getIoRef().getInputs();
        vPanel.add((Widget)new Label(this.i18n.QuickFormInputsToBeAdded()));
        vPanel.add((Widget)this.toGrid(inputs, this.selectedInputs));
        List outputs = row.getIoRef().getOutputs();
        vPanel.add((Widget)new Label(this.i18n.QuickFormOutputsToBeAdded()));
        vPanel.add((Widget)this.toGrid(outputs, this.selectedOutputs));
        Label warning = new Label(this.i18n.QuickFormWarning());
        vPanel.add((Widget)warning);
        HorizontalPanel buttons = new HorizontalPanel();
        Button cancelButton = new Button(this.i18n.CancelButton());
        cancelButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.okButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        buttons.add((Widget)this.okButton);
        buttons.add((Widget)cancelButton);
        vPanel.add((Widget)buttons);
        this.setSize("300px", "300px");
        this.setWidget((Widget)vPanel);
    }

    private Grid toGrid(List<TaskPropertyRef> ioList, List<TaskPropertyRef> selectedIos) {
        Grid grid = new Grid(ioList == null ? 1 : ioList.size(), 2);
        if (ioList != null) {
            for (int index = 0; index < ioList.size(); ++index) {
                TaskPropertyRef io = ioList.get(index);
                CheckBox checkBox = new CheckBox();
                checkBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
                checkBox.setValue(Boolean.TRUE);
                selectedIos.add(io);
                grid.setWidget(index, 0, (Widget)checkBox);
                grid.setWidget(index, 1, (Widget)new Label(io.getName()));
            }
        }
        return grid;
    }

    public HandlerRegistration addOkHandler(ClickHandler handler) {
        return this.okButton.addClickHandler(handler);
    }

    public List<TaskPropertyRef> getSelectedInputs() {
        return this.selectedInputs;
    }

    public List<TaskPropertyRef> getSelectedOutputs() {
        return this.selectedOutputs;
    }

    static /* synthetic */ FormBuilderService access$000(QuickFormPanel x0) {
        return x0.server;
    }

    static /* synthetic */ EventBus access$100(QuickFormPanel x0) {
        return x0.bus;
    }
}

