/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.command;

import com.allen_sauer.gwt.dnd.client.DragContext;
import com.allen_sauer.gwt.dnd.client.drop.AbstractDropController;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jbpm.formapi.client.CommonGlobals;
import org.jbpm.formapi.client.form.FBCompositeItem;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.client.form.PhantomPanel;
import org.jbpm.formapi.client.menu.FBMenuItem;
import org.jbpm.formapi.common.panels.MovablePanel;
import org.jbpm.formbuilder.client.bus.UndoableEvent;
import org.jbpm.formbuilder.client.bus.UndoableHandler;
import org.jbpm.formbuilder.client.layout.LayoutView;

public class DropFormItemController
extends AbstractDropController {
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private final List<PhantomPanel> phantoms = new ArrayList();
    private final LayoutView layoutView;

    public DropFormItemController(Widget dropTarget, LayoutView layoutView) {
        super(dropTarget);
        this.layoutView = layoutView;
    }

    public void onDrop(DragContext context) {
        Widget drag = context.draggable;
        int x = context.mouseX;
        int y = context.mouseY;
        if (drag != null && drag instanceof FBMenuItem) {
            this.addMenuItem(drag, x, y);
        } else if (drag != null && drag instanceof MovablePanel) {
            this.moveFormItem(drag, x, y);
        }
    }

    private void addMenuItem(Widget drag, int x, int y) {
        FBMenuItem menuItem = (FBMenuItem)drag;
        FBFormItem formItem = menuItem.buildWidget();
        formItem.setDesiredPosition(x, y);
        HashMap<String, Object> dataSnapshot = new HashMap<String, Object>();
        dataSnapshot.put("formItem", formItem);
        dataSnapshot.put("menuItem", menuItem);
        dataSnapshot.put("x", x);
        dataSnapshot.put("y", y);
        this.bus.fireEvent((GwtEvent)new UndoableEvent(dataSnapshot, (UndoableHandler)new /* Unavailable Anonymous Inner Class!! */));
    }

    private void moveFormItem(Widget drag, int x, int y) {
        MovablePanel movable = (MovablePanel)drag;
        FBFormItem formItem = (FBFormItem)movable.getOldContainer();
        formItem.setDesiredPosition(x, y);
        HashMap<String, Object> dataSnapshot = new HashMap<String, Object>();
        dataSnapshot.put("formItem", formItem);
        dataSnapshot.put("movable", movable);
        dataSnapshot.put("oldMovableX", movable.getAbsoluteLeft());
        dataSnapshot.put("oldMovableY", movable.getAbsoluteTop());
        dataSnapshot.put("x", x);
        dataSnapshot.put("y", y);
        this.bus.fireEvent((GwtEvent)new UndoableEvent(dataSnapshot, (UndoableHandler)new /* Unavailable Anonymous Inner Class!! */));
    }

    public void onEnter(DragContext context) {
        super.onEnter(context);
        this.clearPhantoms();
        this.addPhantoms(context);
    }

    public void onMove(DragContext context) {
        super.onMove(context);
        this.clearPhantoms();
        this.addPhantoms(context);
    }

    public void onLeave(DragContext context) {
        super.onLeave(context);
        this.clearPhantoms();
    }

    protected void clearPhantoms() {
        for (PhantomPanel phantom : this.phantoms) {
            phantom.removeFromParent();
        }
        this.phantoms.clear();
    }

    protected void addPhantoms(DragContext context) {
        Widget drag = context.draggable;
        int x = context.mouseX;
        int y = context.mouseY;
        if (drag != null && (drag instanceof FBMenuItem || drag instanceof MovablePanel)) {
            HasWidgets panel = this.layoutView.getUnderlyingLayout(Integer.valueOf(x), Integer.valueOf(y));
            if (panel instanceof FBCompositeItem) {
                FBCompositeItem container = (FBCompositeItem)panel;
                this.phantoms.add(new PhantomPanel(container, x, y));
            } else if (((Widget)panel).getParent() instanceof FBCompositeItem) {
                FBCompositeItem container = (FBCompositeItem)((Widget)panel).getParent();
                this.phantoms.add(new PhantomPanel(container, x, y));
            }
        }
    }

    static /* synthetic */ LayoutView access$000(DropFormItemController x0) {
        return x0.layoutView;
    }

    static /* synthetic */ EventBus access$100(DropFormItemController x0) {
        return x0.bus;
    }
}

