/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.user.client.ui.DoubleBox;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.NumberFieldRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class NumberFieldFormItem
extends FBFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final DoubleBox doubleBox = new DoubleBox();
    private Double defaultContent = null;
    private String name = null;
    private String id = null;
    private String title = null;
    private Integer maxlength = null;

    public NumberFieldFormItem() {
        this(new ArrayList());
    }

    public NumberFieldFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.add((Widget)this.doubleBox);
        this.setWidth("150px");
        this.setHeight("25px");
        this.doubleBox.setWidth(this.getWidth());
        this.doubleBox.setHeight(this.getHeight());
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("inputDefaultContent", this.defaultContent);
        map.put("name", this.name);
        map.put("height", this.getHeight());
        map.put("width", this.getWidth());
        map.put("maxlength", this.maxlength);
        map.put("title", this.title);
        map.put("id", this.id);
        return map;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.defaultContent = this.extractDouble(asPropertiesMap.get("inputDefaultContent"));
        this.name = this.extractString(asPropertiesMap.get("name"));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.title = this.extractString(asPropertiesMap.get("title"));
        this.maxlength = this.extractInt(asPropertiesMap.get("maxlength"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.populate(this.doubleBox);
    }

    private void populate(DoubleBox doubleBox) {
        if (this.defaultContent != null) {
            doubleBox.setValue((Object)this.defaultContent);
        }
        if (this.name != null) {
            doubleBox.setName(this.name);
        }
        if (this.getHeight() != null) {
            doubleBox.setHeight(this.getHeight());
        }
        if (this.getWidth() != null) {
            doubleBox.setWidth(this.getWidth());
        }
        if (this.title != null) {
            doubleBox.setTitle(this.title);
        }
        if (this.maxlength != null) {
            doubleBox.setMaxLength(this.maxlength.intValue());
        }
    }

    public FormItemRepresentation getRepresentation() {
        NumberFieldRepresentation rep = (NumberFieldRepresentation)super.getRepresentation((FormItemRepresentation)new NumberFieldRepresentation());
        rep.setDefaultValue(this.defaultContent);
        rep.setName(this.name);
        rep.setId(this.id);
        rep.setMaxLength(this.maxlength);
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof NumberFieldRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "TextFieldRepresentation"));
        }
        super.populate(rep);
        NumberFieldRepresentation nrep = (NumberFieldRepresentation)rep;
        this.defaultContent = nrep.getDefaultValue();
        this.name = nrep.getName();
        this.id = nrep.getId();
        this.maxlength = nrep.getMaxLength();
        if (nrep.getWidth() != null && !"".equals(nrep.getWidth())) {
            this.setWidth(nrep.getWidth());
        }
        if (nrep.getHeight() != null && !"".equals(nrep.getHeight())) {
            this.setHeight(nrep.getHeight());
        }
        this.populate(this.doubleBox);
    }

    public FBFormItem cloneItem() {
        NumberFieldFormItem clone = (NumberFieldFormItem)super.cloneItem((FBFormItem)new NumberFieldFormItem());
        clone.defaultContent = this.defaultContent;
        clone.setHeight(this.getHeight());
        clone.id = this.id;
        clone.maxlength = this.maxlength;
        clone.name = this.name;
        clone.title = this.title;
        clone.setWidth(this.getWidth());
        clone.populate(clone.doubleBox);
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> formData) {
        DoubleBox tb = new DoubleBox();
        this.populate(tb);
        Object input = this.getInputValue(formData);
        if (input != null) {
            String s = input.toString();
            tb.setValue((Object)(s.equals("") ? null : Double.valueOf(s)));
        }
        if (this.getOutput() != null && this.getOutput().getName() != null) {
            tb.setName(this.getOutput().getName());
        }
        super.populateActions(tb.getElement());
        return tb;
    }
}

