/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.client.form.LayoutFormItem;
import org.jbpm.formapi.client.form.PhantomPanel;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.AbsolutePanelRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class AbsoluteLayoutFormItem
extends LayoutFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private AbsolutePanel panel = new /* Unavailable Anonymous Inner Class!! */;
    private String id;
    private String oldStyleName = null;

    public AbsoluteLayoutFormItem() {
        this(new ArrayList());
    }

    public AbsoluteLayoutFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.add((Widget)this.panel);
        this.setSize("90px", "90px");
        this.panel.setSize(this.getWidth(), this.getHeight());
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.id);
        map.put("height", this.getHeight());
        map.put("width", this.getWidth());
        return map;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.populate(this.panel);
    }

    private void populate(AbsolutePanel panel) {
        if (this.getHeight() != null) {
            panel.setHeight(this.getHeight());
        }
        if (this.getWidth() != null) {
            panel.setWidth(this.getWidth());
        }
    }

    public FormItemRepresentation getRepresentation() {
        AbsolutePanelRepresentation rep = (AbsolutePanelRepresentation)super.getRepresentation((FormItemRepresentation)new AbsolutePanelRepresentation());
        rep.setId(this.id);
        for (FBFormItem item : this.getItems()) {
            rep.addItem(item.getRepresentation(), item.getDesiredX() - this.panel.getAbsoluteLeft(), item.getDesiredY() - this.panel.getAbsoluteTop());
        }
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof AbsolutePanelRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "AbsolutePanelRepresentation"));
        }
        super.populate(rep);
        AbsolutePanelRepresentation arep = (AbsolutePanelRepresentation)rep;
        this.panel.clear();
        this.getItems().clear();
        if (arep.getItems() != null) {
            for (Map.Entry entry : arep.getItems().entrySet()) {
                FBFormItem item = LayoutFormItem.createItem((FormItemRepresentation)((FormItemRepresentation)entry.getValue()));
                item.setDesiredPosition(((AbsolutePanelRepresentation.Position)entry.getKey()).getX(), ((AbsolutePanelRepresentation.Position)entry.getKey()).getY());
                this.add(item);
            }
        }
        this.populate(this.panel);
    }

    public FBFormItem cloneItem() {
        AbsoluteLayoutFormItem clone = new AbsoluteLayoutFormItem(this.getFormEffects());
        clone.setHeight(this.getHeight());
        clone.id = this.id;
        clone.setWidth(this.getWidth());
        clone.populate(clone.panel);
        for (FBFormItem item : this.getItems()) {
            clone.add(item.cloneItem());
        }
        return clone;
    }

    public boolean add(FBFormItem item) {
        int left = item.getDesiredX();
        int top = item.getDesiredY();
        this.panel.add((Widget)item, left - this.panel.getAbsoluteLeft(), top - this.panel.getAbsoluteTop());
        return super.add(item);
    }

    public boolean remove(Widget child) {
        return super.remove(child);
    }

    public HasWidgets getPanel() {
        return this.panel;
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        AbsolutePanel ap = new AbsolutePanel();
        this.populate(ap);
        for (FBFormItem item : this.getItems()) {
            ap.add(item.cloneDisplay(data), this.getAbsoluteLeft() - item.getDesiredX(), this.getAbsoluteTop() - item.getDesiredY());
        }
        super.populateActions(ap.getElement());
        return ap;
    }

    public void add(PhantomPanel phantom, int x, int y) {
        String styleName = phantom.getStyleName();
        this.oldStyleName = this.getStyleName();
        this.setStyleName(styleName);
    }

    public void replacePhantom(FBFormItem item) {
        if (this.oldStyleName == null) {
            this.removeStyleName(this.getStyleName());
        } else {
            this.setStyleName(this.oldStyleName);
        }
        this.oldStyleName = null;
        this.add(item);
    }
}

