/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.LinkElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.client.form.HasSourceReference;
import org.jbpm.formapi.client.form.LayoutFormItem;
import org.jbpm.formapi.client.form.PhantomPanel;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.CSSPanelRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class CSSLayoutFormItem
extends LayoutFormItem
implements HasSourceReference {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private FlowPanel panel = new /* Unavailable Anonymous Inner Class!! */;
    private LinkElement link = Document.get().createLinkElement();
    private String cssStylesheetUrl;
    private String cssClassName;
    private String id;

    public CSSLayoutFormItem() {
        this(new ArrayList());
    }

    public CSSLayoutFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.setSize("190px", "90px");
        this.panel.setSize(this.getWidth(), this.getHeight());
        this.link.setRel("Stylesheet");
        this.link.setType("text/css");
        this.link.setMedia("screen");
        this.panel.getElement().insertFirst((Node)this.link);
        this.add((Widget)this.panel);
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cssStylesheetUrl", this.cssStylesheetUrl);
        map.put("cssClassName", this.cssClassName);
        map.put("id", this.id);
        map.put("width", this.getWidth());
        map.put("height", this.getHeight());
        return map;
    }

    public void saveValues(Map<String, Object> map) {
        this.cssStylesheetUrl = this.extractString(map.get("cssStylesheetUrl"));
        this.cssClassName = this.extractString(map.get("cssClassName"));
        this.id = this.extractString(map.get("id"));
        this.setHeight(this.extractString(map.get("height")));
        this.setWidth(this.extractString(map.get("width")));
        this.populate(this.panel, this.link);
    }

    private void populate(FlowPanel panel, LinkElement style) {
        if (this.getHeight() != null) {
            panel.setHeight(this.getHeight());
        }
        if (this.cssClassName != null) {
            panel.setStyleName(this.cssClassName);
        }
        if (this.getWidth() != null) {
            panel.setWidth(this.getWidth());
        }
        if (this.cssStylesheetUrl != null) {
            style.setHref(this.cssStylesheetUrl);
        }
    }

    public FormItemRepresentation getRepresentation() {
        CSSPanelRepresentation rep = (CSSPanelRepresentation)super.getRepresentation((FormItemRepresentation)new CSSPanelRepresentation());
        ArrayList<FormItemRepresentation> items = new ArrayList<FormItemRepresentation>();
        for (FBFormItem item : this.getItems()) {
            items.add(item.getRepresentation());
        }
        rep.setItems(items);
        rep.setId(this.id);
        rep.setCssClassName(this.cssClassName);
        rep.setCssStylesheetUrl(this.cssStylesheetUrl);
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof CSSPanelRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "CSSPanelRepresentation"));
        }
        super.populate(rep);
        CSSPanelRepresentation crep = (CSSPanelRepresentation)rep;
        this.cssClassName = crep.getCssClassName();
        this.id = crep.getId();
        this.cssStylesheetUrl = crep.getCssStylesheetUrl();
        super.getItems().clear();
        this.populate(this.panel, this.link);
        if (crep.getItems() != null) {
            for (FormItemRepresentation item : crep.getItems()) {
                this.add(LayoutFormItem.createItem((FormItemRepresentation)item));
            }
        }
    }

    public FBFormItem cloneItem() {
        CSSLayoutFormItem clone = (CSSLayoutFormItem)super.cloneItem((FBFormItem)new CSSLayoutFormItem(this.getFormEffects()));
        clone.cssClassName = this.cssClassName;
        clone.cssStylesheetUrl = this.cssStylesheetUrl;
        clone.id = this.id;
        clone.populate(clone.panel, clone.link);
        for (FBFormItem item : this.getItems()) {
            clone.add(item.cloneItem());
        }
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        FlowPanel fp = new FlowPanel();
        fp.getElement().insertFirst(this.link.cloneNode(false));
        this.populate(fp, this.link);
        super.populateActions(fp.getElement());
        for (FBFormItem item : this.getItems()) {
            fp.add(item.cloneDisplay(data));
        }
        return fp;
    }

    public HasWidgets getPanel() {
        return this.panel;
    }

    public boolean add(FBFormItem item) {
        this.panel.add((Widget)item);
        return super.add(item);
    }

    public void add(PhantomPanel phantom, int x, int y) {
        this.panel.add((Widget)phantom);
    }

    public void replacePhantom(FBFormItem item) {
        PhantomPanel phantom = null;
        for (Widget widget : this.panel) {
            if (!(widget instanceof PhantomPanel)) continue;
            phantom = (PhantomPanel)widget;
            break;
        }
        if (phantom == null) {
            this.add(item);
        } else {
            int index = this.panel.getWidgetIndex(phantom);
            this.panel.remove((Widget)phantom);
            super.insert(index, item);
        }
    }

    public void setSourceReference(String sourceReference) {
        this.cssStylesheetUrl = sourceReference;
        this.link.setHref(this.cssStylesheetUrl);
    }

    public String getSourceReference() {
        return this.cssStylesheetUrl;
    }

    public List<String> getAllowedTypes() {
        ArrayList<String> retval = new ArrayList<String>();
        retval.add("css");
        return retval;
    }
}

