/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.canvas.client.Canvas;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.client.form.HasSourceReference;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.CanvasRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;
import org.jbpm.formbuilder.client.resources.FormBuilderResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class CanvasFormItem
extends FBFormItem
implements HasSourceReference {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final Canvas canvas = Canvas.createIfSupported();
    private final Label notSupported = new Label(this.i18n.CanvasNotSupported());
    private String fallbackUrl = FormBuilderResources.INSTANCE.canvasNotSupported().getUrl();
    private String cssClassName;
    private String id;
    private String dataType;

    public CanvasFormItem() {
        this(new ArrayList());
    }

    public CanvasFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        if (this.canvas == null) {
            this.add((Widget)this.notSupported);
        } else {
            this.add((Widget)this.canvas);
        }
        this.setWidth("300px");
        this.setHeight("200px");
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cssClassName", this.cssClassName);
        map.put("dataType", this.dataType);
        map.put("height", this.getHeight());
        map.put("width", this.getWidth());
        map.put("fallbackUrl", this.fallbackUrl);
        map.put("id", this.id);
        return map;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.cssClassName = this.extractString(asPropertiesMap.get("cssClassName"));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.fallbackUrl = this.extractString(asPropertiesMap.get("fallbackUrl"));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.dataType = this.extractString(asPropertiesMap.get("dataType"));
        this.populate(this.canvas);
    }

    private void populate(Canvas canvas) {
        if (canvas != null) {
            if (this.cssClassName != null) {
                canvas.setStyleName(this.cssClassName);
            }
            if (this.getHeight() != null) {
                canvas.setHeight(this.getHeight());
            }
            if (this.getWidth() != null) {
                canvas.setWidth(this.getWidth());
            }
        }
    }

    public FormItemRepresentation getRepresentation() {
        CanvasRepresentation rep = (CanvasRepresentation)super.getRepresentation((FormItemRepresentation)new CanvasRepresentation());
        rep.setCssClassName(this.cssClassName);
        rep.setFallbackUrl(this.fallbackUrl);
        rep.setId(this.id);
        rep.setDataType(this.dataType);
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof CanvasRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "CanvasRepresentation"));
        }
        super.populate(rep);
        CanvasRepresentation crep = (CanvasRepresentation)rep;
        this.fallbackUrl = crep.getFallbackUrl();
        this.cssClassName = crep.getCssClassName();
        this.id = crep.getId();
        this.dataType = crep.getDataType();
        this.populate(this.canvas);
    }

    public FBFormItem cloneItem() {
        CanvasFormItem clone = (CanvasFormItem)super.cloneItem((FBFormItem)new CanvasFormItem());
        clone.setHeight(this.getHeight());
        clone.setWidth(this.getWidth());
        clone.fallbackUrl = this.fallbackUrl;
        clone.cssClassName = this.cssClassName;
        clone.dataType = this.dataType;
        clone.id = this.id;
        clone.populate(clone.canvas);
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> formData) {
        Canvas cv = Canvas.createIfSupported();
        if (cv == null) {
            return new Label(this.notSupported.getText());
        }
        this.populate(cv);
        super.populateActions(cv.getElement());
        return cv;
    }

    public void setSourceReference(String sourceReference) {
        this.fallbackUrl = sourceReference;
    }

    public String getSourceReference() {
        return this.fallbackUrl;
    }

    public List<String> getAllowedTypes() {
        ArrayList<String> types = new ArrayList<String>();
        types.add("svg");
        return types;
    }
}

