/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.FileInputRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class FileInputFormItem
extends FBFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private FileUpload fileUpload = new FileUpload();
    private String name;
    private String id;
    private String accept;

    public FileInputFormItem() {
        this(new ArrayList());
    }

    public FileInputFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.add((Widget)this.fileUpload);
        this.setHeight("27px");
        this.setWidth("100px");
        this.fileUpload.setSize(this.getWidth(), this.getHeight());
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.name);
        map.put("id", this.id);
        map.put("width", this.getWidth());
        map.put("height", this.getHeight());
        map.put("accept", this.accept);
        return map;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.name = this.extractString(asPropertiesMap.get("name"));
        this.setWidth(this.extractString(asPropertiesMap.get("width")));
        this.setHeight(this.extractString(asPropertiesMap.get("height")));
        this.id = this.extractString(asPropertiesMap.get("id"));
        this.accept = this.extractString(asPropertiesMap.get("accept"));
        this.populate(this.fileUpload);
    }

    private void populate(FileUpload fileUpload) {
        if (this.name != null) {
            fileUpload.setName(this.name);
        }
        if (this.getWidth() != null) {
            fileUpload.setWidth(this.getWidth());
        }
        if (this.getHeight() != null) {
            fileUpload.setHeight(this.getHeight());
        }
    }

    public FormItemRepresentation getRepresentation() {
        FileInputRepresentation rep = (FileInputRepresentation)super.getRepresentation((FormItemRepresentation)new FileInputRepresentation());
        rep.setId(this.id);
        rep.setName(this.name);
        rep.setAccept(this.accept);
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof FileInputRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "FileInputRepresentation"));
        }
        super.populate(rep);
        FileInputRepresentation frep = (FileInputRepresentation)rep;
        this.id = frep.getId();
        this.name = frep.getName();
        this.accept = frep.getAccept();
        this.populate(this.fileUpload);
    }

    public FBFormItem cloneItem() {
        FileInputFormItem clone = new FileInputFormItem(this.getFormEffects());
        clone.accept = this.accept;
        clone.setHeight(this.getHeight());
        clone.id = this.id;
        clone.name = this.name;
        clone.setWidth(this.getWidth());
        clone.populate(clone.fileUpload);
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        FileUpload fu = new FileUpload();
        this.populate(fu);
        if (this.getOutput() != null && this.getOutput().getName() != null) {
            fu.setName(this.getOutput().getName());
        }
        super.populateActions(fu.getElement());
        return fu;
    }
}

