/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.form.items;

import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import com.gwtent.reflection.client.Reflectable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.effect.FBFormEffect;
import org.jbpm.formapi.client.form.FBFormItem;
import org.jbpm.formapi.client.form.FBInplaceEditor;
import org.jbpm.formapi.shared.api.FormItemRepresentation;
import org.jbpm.formapi.shared.api.items.ServerTransformationRepresentation;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.form.editors.ServerScriptEditor;
import org.jbpm.formbuilder.client.form.items.ServerTransformationFormItem;
import org.jbpm.formbuilder.client.messages.I18NConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Reflectable
public class ServerTransformationFormItem
extends FBFormItem {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private Label scriptMarker = new Label("{ script }");
    private TextArea script = new TextArea();
    private String language;

    public ServerTransformationFormItem() {
        this(new ArrayList());
    }

    public ServerTransformationFormItem(List<FBFormEffect> formEffects) {
        super(formEffects);
        this.scriptMarker.setStyleName("transformationBlockBorder");
        this.add((Widget)this.scriptMarker);
    }

    public Map<String, Object> getFormItemPropertiesMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("language", this.language);
        return map;
    }

    public void saveValues(Map<String, Object> asPropertiesMap) {
        this.language = this.extractString(asPropertiesMap.get("language"));
    }

    public FormItemRepresentation getRepresentation() {
        ServerTransformationRepresentation rep = (ServerTransformationRepresentation)this.getRepresentation((FormItemRepresentation)new ServerTransformationRepresentation());
        rep.setScript(this.script.getValue());
        rep.setLanguage(this.language);
        return rep;
    }

    public void populate(FormItemRepresentation rep) throws FormBuilderException {
        if (!(rep instanceof ServerTransformationRepresentation)) {
            throw new FormBuilderException(this.i18n.RepNotOfType(rep.getClass().getName(), "ServerTransformationRepresentation"));
        }
        super.populate(rep);
        ServerTransformationRepresentation srep = (ServerTransformationRepresentation)rep;
        this.setScriptContent(srep.getScript());
        srep.setLanguage(this.language);
    }

    public FBFormItem cloneItem() {
        ServerTransformationFormItem clone = (ServerTransformationFormItem)this.cloneItem((FBFormItem)new ServerTransformationFormItem(this.getFormEffects()));
        clone.setScriptContent(this.getScriptContent());
        clone.language = this.language;
        return clone;
    }

    public Widget cloneDisplay(Map<String, Object> data) {
        MyWidget display = new MyWidget(this);
        if (this.scriptMarker.getText() != null && !"".equals(this.scriptMarker.getText())) {
            this.eval0(this.scriptMarker.getText());
        }
        display.setHeight(this.getHeight());
        display.setWidth(this.getWidth());
        super.populateActions(display.getElement());
        return display;
    }

    public native void eval0(String var1);

    public FBInplaceEditor createInplaceEditor() {
        return new ServerScriptEditor(this);
    }

    public void setScriptContent(String value) {
        this.script.setValue((Object)value);
    }

    public String getScriptContent() {
        return this.script.getValue();
    }
}

