/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client.notification;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.UmbrellaException;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Set;
import org.jbpm.formapi.client.CommonGlobals;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.messages.I18NConstants;
import org.jbpm.formbuilder.client.notification.NotificationsPresenter;
import org.jbpm.formbuilder.client.notification.NotificationsView;
import org.jbpm.formbuilder.client.resources.FormBuilderResources;

public class CompactNotificationsViewImpl
extends SimplePanel
implements NotificationsView {
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private final VerticalPanel panel = new VerticalPanel();
    private final ScrollPanel scroll = new ScrollPanel((Widget)this.panel);
    private final Image arrowImage = new Image();

    public CompactNotificationsViewImpl() {
        Button show = new Button();
        DOM.setStyleAttribute((Element)show.getElement(), (String)"align", (String)"left");
        DOM.setStyleAttribute((Element)show.getElement(), (String)"textAlign", (String)"left");
        show.setWidth("100%");
        show.setStylePrimaryName("fbStackPanel");
        show.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.panel.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
        this.scroll.addStyleName("notificationsView");
        this.scroll.setSize("100%", "200px");
        this.arrowImage.setResource(FormBuilderResources.INSTANCE.arrowDown());
        VerticalPanel vPanel = new VerticalPanel();
        vPanel.setWidth("100%");
        Grid table = this.getButtonText();
        show.setHTML(new SafeHtmlBuilder().appendHtmlConstant(table.toString()).toSafeHtml());
        this.scroll.setVisible(false);
        vPanel.add((Widget)show);
        vPanel.add((Widget)this.scroll);
        this.setWidget((Widget)vPanel);
        new NotificationsPresenter((NotificationsView)this);
    }

    private Grid getButtonText() {
        Grid buttonText = new Grid(1, 2);
        buttonText.getCellFormatter().setHorizontalAlignment(0, 0, HasHorizontalAlignment.ALIGN_LEFT);
        buttonText.getCellFormatter().setHorizontalAlignment(0, 1, HasHorizontalAlignment.ALIGN_RIGHT);
        buttonText.setWidget(0, 0, (Widget)new HTML("<strong>" + this.i18n.Notifications() + "</strong>"));
        buttonText.setWidth("100%");
        buttonText.setBorderWidth(0);
        buttonText.setCellPadding(0);
        buttonText.setCellSpacing(0);
        buttonText.setWidget(0, 1, (Widget)this.arrowImage);
        return buttonText;
    }

    public String getColorCss(String name) {
        String colorCss = "greenNotification";
        if ("WARN".equals(name)) {
            colorCss = "orangeNotification";
        } else if ("ERROR".equals(name)) {
            colorCss = "redNotification";
        }
        return colorCss;
    }

    public void append(String colorCss, String message, Throwable error) {
        HTML html = new HTML();
        if (colorCss != null) {
            html.setStyleName(colorCss);
        }
        StringBuilder msg = new StringBuilder(message).append("<br/>");
        while (error != null) {
            Set causes;
            msg.append(this.stringStackTrace(error));
            if (error instanceof UmbrellaException && (causes = ((UmbrellaException)error).getCauses()) != null) {
                for (Throwable cause : causes) {
                    msg.append(this.stringStackTrace(cause));
                }
            }
            if (error.getCause() != null && !error.equals(error.getCause())) {
                error = error.getCause();
                msg.append(this.i18n.CausedBy());
                continue;
            }
            error = null;
        }
        html.setHTML(msg.toString());
        this.panel.add((Widget)html);
        if (!this.scroll.isVisible()) {
            this.scroll.setVisible(true);
        }
    }

    private String stringStackTrace(Throwable error) {
        StringBuilder msg = new StringBuilder();
        msg.append(error.getClass().getName()).append(": ").append(error.getLocalizedMessage()).append("<br/>");
        StackTraceElement[] trace = error.getStackTrace();
        for (int index = 0; trace != null && index < trace.length; ++index) {
            msg.append(this.i18n.StackTraceLine(trace[index].getClassName(), trace[index].getMethodName(), trace[index].getFileName(), String.valueOf(trace[index].getLineNumber()))).append("<br/>");
        }
        return msg.toString();
    }

    static /* synthetic */ ScrollPanel access$000(CompactNotificationsViewImpl x0) {
        return x0.scroll;
    }

    static /* synthetic */ Image access$100(CompactNotificationsViewImpl x0) {
        return x0.arrowImage;
    }

    static /* synthetic */ EventBus access$200(CompactNotificationsViewImpl x0) {
        return x0.bus;
    }
}

