/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server.task;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.compiler.BPMN2ProcessFactory;
import org.drools.compiler.BPMN2ProcessProvider;
import org.drools.io.Resource;
import org.drools.io.impl.ByteArrayResource;
import org.jbpm.formbuilder.server.GuvnorHelper;
import org.jbpm.formbuilder.server.task.TaskDefinitionsSemanticModule;
import org.jbpm.formbuilder.server.task.TaskRepoHelper;
import org.jbpm.formbuilder.server.xml.AssetDTO;
import org.jbpm.formbuilder.server.xml.PackageDTO;
import org.jbpm.formbuilder.server.xml.PackageListDTO;
import org.jbpm.formbuilder.shared.task.TaskDefinitionService;
import org.jbpm.formbuilder.shared.task.TaskRef;
import org.jbpm.formbuilder.shared.task.TaskServiceException;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuvnorTaskDefinitionService
implements TaskDefinitionService,
InitializingBean {
    private final TaskRepoHelper repo = new TaskRepoHelper();
    private final TaskDefinitionsSemanticModule module = new TaskDefinitionsSemanticModule(this.repo);
    private final BPMN2ProcessProvider provider = new /* Unavailable Anonymous Inner Class!! */;
    private GuvnorHelper helper;
    private String baseUrl;
    private String user;
    private String password;

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void afterPropertiesSet() throws Exception {
        this.helper = new GuvnorHelper(this.baseUrl, this.user, this.password);
    }

    public void setHelper(GuvnorHelper helper) {
        this.helper = helper;
    }

    public GuvnorHelper getHelper() {
        return this.helper;
    }

    public List<TaskRef> query(String pkgName, String filter) throws TaskServiceException {
        HttpClient client = this.helper.getHttpClient();
        GetMethod method = null;
        try {
            method = this.helper.createGetMethod(this.helper.getApiSearchUrl(pkgName));
            this.helper.setAuth(client, (HttpMethod)method);
            client.executeMethod((HttpMethod)method);
            Properties props = new Properties();
            props.load(method.getResponseBodyAsStream());
            ArrayList<TaskRef> tasks = new ArrayList<TaskRef>();
            for (Object key : props.keySet()) {
                List processTasks;
                String content;
                String assetId = key.toString();
                if (!assetId.endsWith(ResourceType.BPMN2.getDefaultExtension()) && !assetId.endsWith(ResourceType.DRF.getDefaultExtension()) && !assetId.endsWith("bpmn2") || (content = this.getTaskDefinitionContent(pkgName, assetId)) == null || "".equals(content) || (processTasks = this.getProcessTasks(content, assetId)) == null) continue;
                for (TaskRef ref : processTasks) {
                    if (filter == null || "".equals(filter)) {
                        tasks.add(ref);
                        continue;
                    }
                    if (!ref.getProcessId().contains(assetId) && !ref.getTaskName().contains(filter)) continue;
                    tasks.add(ref);
                }
            }
            ArrayList<TaskRef> arrayList = tasks;
            return arrayList;
        }
        catch (IOException e) {
            throw new TaskServiceException("Couldn't read task definitions", (Throwable)e);
        }
        catch (Exception e) {
            throw new TaskServiceException("Unexpected error", (Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaskRef> getTasksByName(String pkgName, String processId, String taskId) throws TaskServiceException {
        HttpClient client = this.helper.getHttpClient();
        ArrayList<TaskRef> retval = new ArrayList<TaskRef>();
        if (pkgName != null) {
            GetMethod call = this.helper.createGetMethod(this.helper.getRestBaseUrl());
            try {
                this.helper.setAuth(client, (HttpMethod)call);
                call.addRequestHeader("Accept", "application/xml");
                client.executeMethod((HttpMethod)call);
                PackageListDTO dto = (PackageListDTO)this.helper.jaxbTransformation(PackageListDTO.class, call.getResponseBodyAsStream(), PackageListDTO.RELATED_CLASSES);
                PackageDTO pkg = dto.getSelectedPackage(pkgName);
                ArrayList<String> urls = new ArrayList<String>();
                for (String url : pkg.getAssets()) {
                    GetMethod subCall = this.helper.createGetMethod(url);
                    try {
                        this.helper.setAuth(client, (HttpMethod)call);
                        subCall.addRequestHeader("Accept", "application/xml");
                        client.executeMethod((HttpMethod)subCall);
                        AssetDTO subDto = (AssetDTO)this.helper.jaxbTransformation(AssetDTO.class, subCall.getResponseBodyAsStream(), AssetDTO.RELATED_CLASSES);
                        if (!subDto.getMetadata().getFormat().equals("bpmn2")) continue;
                        urls.add(subDto.getSourceLink());
                    }
                    finally {
                        subCall.releaseConnection();
                    }
                }
                for (String url : urls) {
                    GetMethod processCall = this.helper.createGetMethod(url);
                    try {
                        this.helper.setAuth(client, (HttpMethod)processCall);
                        client.executeMethod((HttpMethod)processCall);
                        String processContent = processCall.getResponseBodyAsString();
                        List tasks = this.getProcessTasks(processContent, "any.bpmn2");
                        for (TaskRef task : tasks) {
                            if (task.getProcessId() == null || !task.getProcessId().equals(processId) || task.getTaskId() == null || !task.getTaskId().equals(taskId)) continue;
                            retval.add(task);
                        }
                    }
                    finally {
                        processCall.releaseConnection();
                    }
                }
            }
            catch (JAXBException e) {
                throw new TaskServiceException("Couldn't read task definition for package:" + pkgName + ", process: " + processId + ", task: " + taskId, (Throwable)e);
            }
            catch (IOException e) {
                throw new TaskServiceException("Couldn't read task definition for package:" + pkgName + ", process: " + processId + ", task: " + taskId, (Throwable)e);
            }
            catch (Exception e) {
                throw new TaskServiceException("Unexpected error", (Throwable)e);
            }
            finally {
                call.releaseConnection();
            }
        }
        return retval;
    }

    public String getContainingPackage(String uuid) throws TaskServiceException {
        try {
            return this.helper.getPackageNameByContentUUID(uuid);
        }
        catch (JAXBException e) {
            throw new TaskServiceException("problem querying package", (Throwable)e);
        }
        catch (IOException e) {
            throw new TaskServiceException("problem querying package", (Throwable)e);
        }
        catch (Exception e) {
            throw new TaskServiceException("Unexpected error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskRef getTaskByUUID(String packageName, String userTask, String uuid) throws TaskServiceException {
        block19: {
            HttpClient client = this.helper.getHttpClient();
            if (packageName != null) {
                GetMethod call = this.helper.createGetMethod(this.helper.getRestBaseUrl());
                try {
                    this.helper.setAuth(client, (HttpMethod)call);
                    call.addRequestHeader("Accept", "application/xml");
                    client.executeMethod((HttpMethod)call);
                    PackageListDTO dto = (PackageListDTO)this.helper.jaxbTransformation(PackageListDTO.class, call.getResponseBodyAsStream(), PackageListDTO.RELATED_CLASSES);
                    String processUrl = null;
                    String format = null;
                    PackageDTO pkg = dto.getSelectedPackage(packageName);
                    for (String url : pkg.getAssets()) {
                        GetMethod subCall = this.helper.createGetMethod(url);
                        try {
                            this.helper.setAuth(client, (HttpMethod)subCall);
                            subCall.addRequestHeader("Accept", "application/xml");
                            client.executeMethod((HttpMethod)subCall);
                            AssetDTO subDto = (AssetDTO)this.helper.jaxbTransformation(AssetDTO.class, subCall.getResponseBodyAsStream(), AssetDTO.RELATED_CLASSES);
                            if (!subDto.getMetadata().getUuid().equals(uuid)) continue;
                            processUrl = subDto.getSourceLink();
                            format = subDto.getMetadata().getFormat();
                            break;
                        }
                        finally {
                            subCall.releaseConnection();
                        }
                    }
                    if (format == null || !"bpmn2".equals(format)) break block19;
                    GetMethod processCall = this.helper.createGetMethod(processUrl);
                    try {
                        this.helper.setAuth(client, (HttpMethod)processCall);
                        client.executeMethod((HttpMethod)processCall);
                        String processContent = processCall.getResponseBodyAsString();
                        List tasks = this.getProcessTasks(processContent, "any." + format);
                        Iterator i$ = tasks.iterator();
                        while (true) {
                            if (i$.hasNext()) {
                                TaskRef task = (TaskRef)i$.next();
                                if (!this.isReferencedTask(userTask, task)) continue;
                                TaskRef taskRef = task;
                                return taskRef;
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        processCall.releaseConnection();
                    }
                }
                catch (JAXBException e) {
                    throw new TaskServiceException("Couldn't read task definition" + uuid + " : " + userTask, (Throwable)e);
                }
                catch (IOException e) {
                    throw new TaskServiceException("Couldn't read task definition " + uuid + " : " + userTask, (Throwable)e);
                }
                catch (Exception e) {
                    throw new TaskServiceException("Unexpected error", (Throwable)e);
                }
                finally {
                    call.releaseConnection();
                }
            }
        }
        return null;
    }

    public TaskRef getBPMN2Task(String bpmn2ProcessContent, String processName, String userTask) throws TaskServiceException {
        TaskRef retval = null;
        List tasks = this.getProcessTasks(bpmn2ProcessContent, processName);
        if (tasks != null) {
            for (TaskRef task : tasks) {
                if (!task.getTaskName().equals(userTask)) continue;
                retval = task;
                break;
            }
        }
        return retval;
    }

    private boolean isReferencedTask(String userTask, TaskRef task) {
        boolean emptyUserTask = userTask == null || "".equals(userTask);
        boolean taskIsStartProcess = task.getTaskId().equals("startProcess");
        boolean taskIsSearchedTask = userTask != null && task.getTaskId().equals(userTask);
        return emptyUserTask && taskIsStartProcess || taskIsSearchedTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTaskDefinitionContent(String pkgName, String itemName) throws IOException {
        HttpClient client = this.helper.getHttpClient();
        if (itemName != null && !"".equals(itemName)) {
            String getUrl = this.helper.getApiSearchUrl(pkgName) + URLEncoder.encode(itemName, "UTF-8");
            GetMethod method = this.helper.createGetMethod(getUrl);
            try {
                this.helper.setAuth(client, (HttpMethod)method);
                client.executeMethod((HttpMethod)method);
                String string = method.getResponseBodyAsString();
                return string;
            }
            finally {
                method.releaseConnection();
            }
        }
        return "";
    }

    protected List<TaskRef> getProcessTasks(String bpmn2Content, String processName) {
        if (bpmn2Content == null || "".equals(bpmn2Content)) {
            return new ArrayList<TaskRef>();
        }
        if (BPMN2ProcessFactory.getBPMN2ProcessProvider() != this.provider) {
            BPMN2ProcessFactory.setBPMN2ProcessProvider((BPMN2ProcessProvider)this.provider);
        }
        this.repo.clear();
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        boolean isBPMN = processName.toLowerCase().endsWith("bpmn");
        boolean isBPMN2 = processName.toLowerCase().endsWith("bpmn2");
        ResourceType type = isBPMN || isBPMN2 ? ResourceType.BPMN2 : ResourceType.DRF;
        kbuilder.add((Resource)new ByteArrayResource(bpmn2Content.getBytes()), type);
        if (!kbuilder.hasErrors()) {
            return new ArrayList<TaskRef>(this.repo.getTasks());
        }
        return new ArrayList<TaskRef>();
    }

    static /* synthetic */ TaskDefinitionsSemanticModule access$000(GuvnorTaskDefinitionService x0) {
        return x0.module;
    }
}

