/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.client;

import com.allen_sauer.gwt.dnd.client.PickupDragController;
import com.allen_sauer.gwt.dnd.client.drop.DropController;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.jbpm.formapi.client.CommonGlobals;
import org.jbpm.formapi.client.FormBuilderException;
import org.jbpm.formapi.client.bus.ui.NotificationEvent;
import org.jbpm.formapi.client.form.FormEncodingClientFactory;
import org.jbpm.formapi.shared.api.FormRepresentation;
import org.jbpm.formapi.shared.form.FormEncodingFactory;
import org.jbpm.formapi.shared.form.FormRepresentationDecoder;
import org.jbpm.formapi.shared.form.FormRepresentationEncoder;
import org.jbpm.formbuilder.client.FormBuilderGlobals;
import org.jbpm.formbuilder.client.FormBuilderService;
import org.jbpm.formbuilder.client.FormBuilderView;
import org.jbpm.formbuilder.client.FormExporter;
import org.jbpm.formbuilder.client.HistoryPresenter;
import org.jbpm.formbuilder.client.JsonLoadInput;
import org.jbpm.formbuilder.client.RoleUtils;
import org.jbpm.formbuilder.client.bus.ui.EmbededIOReferenceEvent;
import org.jbpm.formbuilder.client.bus.ui.NotificationsVisibleEvent;
import org.jbpm.formbuilder.client.bus.ui.RepresentationFactoryPopulatedEvent;
import org.jbpm.formbuilder.client.bus.ui.UpdateFormViewEvent;
import org.jbpm.formbuilder.client.bus.ui.UserIsLoggedOutEvent;
import org.jbpm.formbuilder.client.command.DisposeDropController;
import org.jbpm.formbuilder.client.edition.EditionViewImpl;
import org.jbpm.formbuilder.client.layout.LayoutViewImpl;
import org.jbpm.formbuilder.client.menu.AnimatedMenuViewImpl;
import org.jbpm.formbuilder.client.messages.I18NConstants;
import org.jbpm.formbuilder.client.notification.CompactNotificationsViewImpl;
import org.jbpm.formbuilder.client.options.OptionsViewImpl;
import org.jbpm.formbuilder.client.tasks.IoAssociationViewImpl;
import org.jbpm.formbuilder.client.toolbar.ToolBarViewImpl;
import org.jbpm.formbuilder.client.tree.TreeViewImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormBuilderController {
    private final EventBus bus = CommonGlobals.getInstance().getEventBus();
    private final I18NConstants i18n = FormBuilderGlobals.getInstance().getI18n();
    private final FormBuilderService model = FormBuilderGlobals.getInstance().getService();
    private final FormBuilderView view;
    private final FormExporter formExporter;

    public FormBuilderController(RootPanel rootPanel, FormBuilderView fbView) {
        this.view = fbView;
        GWT.setUncaughtExceptionHandler((GWT.UncaughtExceptionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.bus.addHandler(UserIsLoggedOutEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        new HistoryPresenter();
        RoleUtils.getInstance();
        FormEncodingFactory.register((FormRepresentationEncoder)FormEncodingClientFactory.getEncoder(), (FormRepresentationDecoder)FormEncodingClientFactory.getDecoder());
        PickupDragController dragController = new PickupDragController((AbsolutePanel)this.view, true);
        dragController.registerDropController((DropController)new DisposeDropController((Widget)this.view));
        CommonGlobals.getInstance().registerDragController(dragController);
        this.formExporter = new FormExporter();
        this.formExporter.start();
        this.view.setNotificationsView((Panel)new CompactNotificationsViewImpl());
        this.view.setMenuView((ScrollPanel)new AnimatedMenuViewImpl());
        this.view.setEditionView((ScrollPanel)new EditionViewImpl());
        this.view.setTreeView((ScrollPanel)new TreeViewImpl());
        this.view.setLayoutView((ScrollPanel)new LayoutViewImpl());
        this.view.setOptionsView((SimplePanel)new OptionsViewImpl());
        this.view.setIoAssociationView((Panel)new IoAssociationViewImpl());
        this.view.setToolBarView((Panel)new ToolBarViewImpl());
        this.bus.addHandler(RepresentationFactoryPopulatedEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.bus.addHandler(NotificationsVisibleEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.populateRepresentationFactory(this.model);
    }

    private void fireEvents(List<GwtEvent<?>> events) {
        if (events != null) {
            for (GwtEvent<?> event : events) {
                this.bus.fireEvent(event);
            }
        }
    }

    private List<GwtEvent<?>> setDataPanel(RootPanel rootPanel) {
        ArrayList retval = new ArrayList();
        String innerHTML = rootPanel.getElement().getInnerHTML();
        if (innerHTML != null && !"".equals(innerHTML)) {
            try {
                JsonLoadInput input = JsonLoadInput.parse((String)innerHTML);
                if (input != null) {
                    if (input.getForm() != null) {
                        if (input.getPackage() != null && !"".equals(input.getPackage())) {
                            this.model.setPackageName(input.getPackage());
                        }
                        retval.add((GwtEvent<?>)new UpdateFormViewEvent(input.getForm()));
                        if (input.getTask() == null && this.hasTaskAssigned(input.getForm())) {
                            this.model.selectIoAssociation(input.getPackage(), input.getForm().getProcessName(), input.getForm().getTaskId());
                        }
                    }
                    retval.add((GwtEvent<?>)new EmbededIOReferenceEvent(input.getTask(), input.getProfile()));
                }
            }
            catch (Exception e) {
                GWT.log((String)"Problem parsing init content", (Throwable)e);
            }
        }
        return retval;
    }

    private boolean hasTaskAssigned(FormRepresentation form) {
        boolean notNull = form != null && form.getProcessName() != null && form.getTaskId() != null;
        return notNull && !"".equals(form.getProcessName().trim()) && !"".equals(form.getTaskId().trim());
    }

    private void setViewPanel(RootPanel rootPanel) {
        rootPanel.getElement().setInnerHTML("");
        rootPanel.getElement().getStyle().setVisibility(Style.Visibility.VISIBLE);
        rootPanel.add((Widget)this.view);
    }

    private void populateRepresentationFactory(FormBuilderService model) {
        try {
            model.populateRepresentationFactory();
        }
        catch (FormBuilderException e) {
            this.bus.fireEvent((GwtEvent)new NotificationEvent(NotificationEvent.Level.ERROR, this.i18n.ProblemLoadingRepresentationFactory(), (Throwable)e));
        }
    }

    static /* synthetic */ I18NConstants access$000(FormBuilderController x0) {
        return x0.i18n;
    }

    static /* synthetic */ EventBus access$100(FormBuilderController x0) {
        return x0.bus;
    }

    static /* synthetic */ FormBuilderService access$200(FormBuilderController x0) {
        return x0.model;
    }

    static /* synthetic */ List access$300(FormBuilderController x0, RootPanel x1) {
        return x0.setDataPanel(x1);
    }

    static /* synthetic */ void access$400(FormBuilderController x0, RootPanel x1) {
        x0.setViewPanel(x1);
    }

    static /* synthetic */ void access$500(FormBuilderController x0, List x1) {
        x0.fireEvents(x1);
    }

    static /* synthetic */ FormBuilderView access$600(FormBuilderController x0) {
        return x0.view;
    }
}

