/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.panels.modeler.backend.indexing;

import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.config.FormSerializationManager;
import org.jbpm.formModeler.editor.type.FormResourceTypeDefinition;
import org.jbpm.formModeler.panels.modeler.backend.indexing.FormVisitor;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.util.KObjectUtil;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.metadata.engine.Indexer;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KObjectKey;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class FormIndexer
implements Indexer {
    private static final Logger logger = LoggerFactory.getLogger(FormIndexer.class);
    @Inject
    @Named(value="ioStrategy")
    protected IOService ioService;
    @Inject
    protected KieProjectService projectService;
    @Inject
    protected FormSerializationManager formSerializationManager;
    @Inject
    protected FormResourceTypeDefinition formType;

    public boolean supportsPath(Path path) {
        return this.formType.accept(Paths.convert((Path)path));
    }

    public KObject toKObject(Path path) {
        KObject index = null;
        try {
            Form form = this.formSerializationManager.loadFormFromXML(this.ioService.readAllString(path).trim(), path.toUri().toString());
            Project project = this.projectService.resolveProject(Paths.convert((Path)path));
            Package pkg = this.projectService.resolvePackage(Paths.convert((Path)path));
            DefaultIndexBuilder builder = new DefaultIndexBuilder(project, pkg);
            FormVisitor formVisitor = new FormVisitor(builder, form);
            formVisitor.visit();
            index = KObjectUtil.toKObject((Path)path, (Set)builder.build());
        }
        catch (Exception e) {
            logger.error("Unable to index '" + path.toUri().toString() + "'.", (Object)e.getMessage());
        }
        return index;
    }

    public KObjectKey toKObjectKey(Path path) {
        return KObjectUtil.toKObjectKey((Path)path);
    }
}

