/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.panels.modeler.backend.indexing;

import java.io.InputStream;
import org.jbpm.formModeler.api.model.DataHolder;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.config.DataHolderManager;
import org.jbpm.formModeler.core.config.FieldTypeManager;
import org.jbpm.formModeler.core.config.FormManagerImpl;
import org.jbpm.formModeler.core.config.FormSerializationManager;
import org.jbpm.formModeler.core.config.FormSerializationManagerImpl;
import org.jbpm.formModeler.core.config.builders.dataHolder.DataHolderBuildConfig;
import org.jbpm.formModeler.core.model.BasicTypeDataHolder;
import org.jbpm.formModeler.core.model.PojoDataHolder;
import org.jbpm.formModeler.dataModeler.model.DataModelerDataHolder;
import org.jbpm.formModeler.panels.modeler.backend.indexing.FormIndexVisitor;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.refactoring.Resource;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class FormIndexVisitorTest {
    public static final String SIMPLE_DATA_HOLDER_FORM = "ReviewAdministration-taskform.form";
    public static final String COMPLEX_DATA_HOLDER_FORM = "PurchaseHeader.form";
    @Mock
    private DataHolderManager dataHolderManager;
    @Mock
    private FieldTypeManager fieldTypeManager;
    private FormSerializationManager serializationManager;

    @Before
    public void init() {
        Mockito.when((Object)this.dataHolderManager.createDataHolderByType((String)Matchers.any(), (DataHolderBuildConfig)Matchers.any())).thenAnswer((Answer)new Answer<DataHolder>(){

            public DataHolder answer(InvocationOnMock invocationOnMock) throws Throwable {
                DataHolder dataHolder = null;
                String holderType = (String)invocationOnMock.getArguments()[0];
                DataHolderBuildConfig config = (DataHolderBuildConfig)invocationOnMock.getArguments()[1];
                if (holderType.equals("dataModelerEntry")) {
                    dataHolder = (DataHolder)Mockito.mock(DataModelerDataHolder.class);
                } else if (holderType.equals("className")) {
                    dataHolder = (DataHolder)Mockito.mock(PojoDataHolder.class);
                } else if (holderType.equals("basicType")) {
                    dataHolder = (DataHolder)Mockito.mock(BasicTypeDataHolder.class);
                }
                if (dataHolder != null) {
                    Mockito.when((Object)dataHolder.getUniqeId()).thenReturn((Object)config.getHolderId());
                    Mockito.when((Object)dataHolder.getInputId()).thenReturn((Object)config.getInputId());
                    Mockito.when((Object)dataHolder.getOuputId()).thenReturn((Object)config.getOutputId());
                    Mockito.when((Object)dataHolder.getRenderColor()).thenReturn((Object)config.getRenderColor());
                    Mockito.when((Object)dataHolder.getClassName()).thenReturn((Object)config.getValue());
                }
                return dataHolder;
            }
        });
        this.serializationManager = new FormSerializationManagerImpl(){
            {
                this.formManager = new FormManagerImpl();
                this.dataHolderManager = FormIndexVisitorTest.this.dataHolderManager;
                this.fieldTypeManager = FormIndexVisitorTest.this.fieldTypeManager;
            }
        };
    }

    @Test
    public void testFormWithSimpleDataHolder() throws Exception {
        this.runTest(SIMPLE_DATA_HOLDER_FORM);
    }

    @Test
    public void testFormWithComplexDataHolder() throws Exception {
        this.runTest(COMPLEX_DATA_HOLDER_FORM);
    }

    protected void runTest(String formName) throws Exception {
        InputStream formInputStream = this.getClass().getResourceAsStream(formName);
        Form form = this.serializationManager.loadFormFromXML(formInputStream);
        FormIndexVisitor visitor = (FormIndexVisitor)Mockito.spy((Object)new FormIndexVisitor(form));
        visitor.visit();
        ((FormIndexVisitor)Mockito.verify((Object)visitor, (VerificationMode)Mockito.times((int)form.getFormFields().size()))).visit((Field)Matchers.any(Field.class), (Resource)Matchers.any());
        ((FormIndexVisitor)Mockito.verify((Object)visitor, (VerificationMode)Mockito.times((int)form.getHolders().size()))).visit((DataHolder)Matchers.any(DataHolder.class));
    }
}

