/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.renderer.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jbpm.formModeler.api.client.FormRenderContextTO;

@Dependent
public class FormRendererWidget
extends Composite {
    private static final String GWT_DEFAULT_LOCALE = "default";
    private static final String FORM_MODELER_DEFAULT_LOCALE = "en";
    boolean canSubmit = false;
    private String ctxUID;
    @Inject
    private Frame frame;

    @PostConstruct
    public void initRenderer() {
        VerticalPanel widget = new VerticalPanel();
        this.initWidget((Widget)widget);
        widget.add((Widget)this.frame);
        this.frame.getElement().getStyle().setBorderWidth(0.0, Style.Unit.PX);
    }

    public void submitForm() {
        if (this.canSubmit) {
            this.submitForm(this.ctxUID, false);
        }
    }

    public void submitFormAndPersist() {
        if (this.canSubmit) {
            this.submitForm(this.ctxUID, true);
        }
    }

    private native void submitForm(String var1, boolean var2);

    public void loadContext(FormRenderContextTO ctx) {
        this.loadContext(ctx.getCtxUID());
    }

    public void loadContext(String ctxUID) {
        this.ctxUID = ctxUID;
        this.frame.getElement().setId("frame_" + ctxUID);
        String localeName = LocaleInfo.getCurrentLocale().getLocaleName();
        if (GWT_DEFAULT_LOCALE.equals(localeName)) {
            localeName = FORM_MODELER_DEFAULT_LOCALE;
        }
        this.frame.setUrl(UriUtils.fromString((String)(GWT.getModuleBaseURL() + "Controller?_fb=frc&_fp=Start&ctxUID=" + ctxUID + "&locale=" + localeName)).asString());
        this.canSubmit = true;
        this.frame.setWidth("100%");
        this.frame.setHeight("300px");
    }

    public boolean isValidContextUID(String ctxUID) {
        return ctxUID != null && ctxUID.startsWith("formRenderCtx_");
    }

    public void resize(int width, int height) {
        this.frame.setWidth(width + "px");
        this.frame.setHeight(height + "px");
    }

    public void endContext() {
        this.canSubmit = false;
        this.frame.setUrl("");
        this.ctxUID = null;
    }
}

