/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.client.docks;

import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.context.DataModelerWorkbenchContext;
import org.kie.workbench.common.screens.datamodeller.client.context.DataModelerWorkbenchContextChangeEvent;
import org.kie.workbench.common.screens.datamodeller.client.context.DataModelerWorkbenchFocusEvent;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.docks.UberfireDockReadyEvent;
import org.uberfire.client.workbench.docks.UberfireDocks;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@Dependent
public class AuthoringWorkbenchDocks {
    @Inject
    private UberfireDocks uberfireDocks;
    @Inject
    protected DataModelerWorkbenchContext dataModelerWBContext;
    private String authoringPerspectiveIdentifier;
    private UberfireDock projectExplorerDock;
    private boolean dataModelerIsHidden;
    private DataModelerContext lastActiveContext;

    public void perspectiveChangeEvent(@Observes UberfireDockReadyEvent dockReadyEvent) {
        if (this.authoringPerspectiveIdentifier != null && dockReadyEvent.getCurrentPerspective().equals(this.authoringPerspectiveIdentifier) && this.projectExplorerDock != null) {
            this.uberfireDocks.expand(this.projectExplorerDock);
        }
    }

    public void setup(String authoringPerspectiveIdentifier, PlaceRequest projectExplorerPlaceRequest) {
        this.authoringPerspectiveIdentifier = authoringPerspectiveIdentifier;
        this.projectExplorerDock = new UberfireDock(UberfireDockPosition.WEST, "ADJUST", projectExplorerPlaceRequest, authoringPerspectiveIdentifier).withSize(400.0).withLabel("Project Explorer");
        this.uberfireDocks.add(new UberfireDock[]{this.projectExplorerDock, new UberfireDock(UberfireDockPosition.EAST, "RANDOM", (PlaceRequest)new DefaultPlaceRequest("DroolsDomainScreen"), authoringPerspectiveIdentifier).withSize(450.0).withLabel("Drools & jBPM"), new UberfireDock(UberfireDockPosition.EAST, "BRIEFCASE", (PlaceRequest)new DefaultPlaceRequest("JPADomainScreen"), authoringPerspectiveIdentifier).withSize(450.0).withLabel("Persistence"), new UberfireDock(UberfireDockPosition.EAST, "COG", (PlaceRequest)new DefaultPlaceRequest("AdvancedDomainScreen"), authoringPerspectiveIdentifier).withSize(450.0).withLabel("Advanced")});
        this.uberfireDocks.disable(UberfireDockPosition.EAST, authoringPerspectiveIdentifier);
    }

    public void onContextChange(@Observes DataModelerWorkbenchContextChangeEvent contextEvent) {
        this.handleDocks();
    }

    private void handleDocks() {
        DataModelerContext context = this.dataModelerWBContext.getActiveContext();
        if (!this.dataModelerIsHidden && this.shouldDisplayWestDocks(context) && this.lastActiveContext != context) {
            this.uberfireDocks.enable(UberfireDockPosition.EAST, this.authoringPerspectiveIdentifier);
            this.lastActiveContext = context;
        } else if (this.dataModelerIsHidden || !this.shouldDisplayWestDocks(context)) {
            this.uberfireDocks.disable(UberfireDockPosition.EAST, this.authoringPerspectiveIdentifier);
            this.lastActiveContext = null;
        }
    }

    public void onDataModelerWorkbenchFocusEvent(@Observes DataModelerWorkbenchFocusEvent event) {
        if (!event.isFocused()) {
            this.dataModelerIsHidden = true;
            this.uberfireDocks.disable(UberfireDockPosition.EAST, this.authoringPerspectiveIdentifier);
        } else {
            this.dataModelerIsHidden = false;
            this.handleDocks();
        }
    }

    private boolean shouldDisplayWestDocks(DataModelerContext context) {
        return context != null && context.getEditionMode() == DataModelerContext.EditionMode.GRAPHICAL_MODE;
    }
}

