/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bui.taglib;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.VariableInfo;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.bui.resources.StaticResourceResolver;
import org.jbpm.formModeler.service.bb.commons.config.componentsFactory.Factory;
import org.jbpm.formModeler.service.bb.mvc.taglib.ContextTag;

public class ImageResolverTag
extends BodyTagSupport {
    private static Log log = LogFactory.getLog((String)ImageResolverTag.class.getName());
    private String imageURL;
    private String relativePath;

    public int doStartTag() throws JspException {
        if (!StringUtils.isEmpty((String)this.relativePath)) {
            this.imageURL = this.getImageResolver().getImagePath(this.relativePath);
            if (!StringUtils.isEmpty((String)this.imageURL)) {
                this.imageURL = ContextTag.getContextPath((String)this.imageURL, (HttpServletRequest)((HttpServletRequest)this.pageContext.getRequest()));
            }
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        try {
            if (StringUtils.isEmpty((String)this.imageURL)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"imageURL is null . Clearing content.");
                }
                if (this.bodyContent != null) {
                    this.imageURL = this.bodyContent.getString();
                    this.bodyContent.clear();
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("imageURL = " + this.imageURL + ". "));
                }
                if (this.id != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Setting " + this.id + " to " + this.imageURL));
                    }
                    this.pageContext.setAttribute(this.id, (Object)this.imageURL, 1);
                    return 0;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Printing imageURL to " + this.imageURL));
                }
                this.pageContext.getOut().print(this.imageURL);
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error building imageURL: ", (Throwable)ex);
            throw new JspException("Exception ", (Throwable)ex);
        }
        return 6;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public StaticResourceResolver getImageResolver() {
        return (StaticResourceResolver)Factory.lookup((String)"org.jbpm.bui.resources.StaticImageResolver");
    }

    public static class TEI
    extends TagExtraInfo {
        public VariableInfo[] getVariableInfo(TagData data) {
            String varName = data.getId();
            if (varName == null) {
                return new VariableInfo[0];
            }
            return new VariableInfo[]{new VariableInfo(varName, "java.lang.String", true, 2)};
        }
    }
}

