/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.formProcessing;

import java.util.Arrays;
import java.util.Collection;
import javax.inject.Inject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jbpm.formModeler.api.client.FormRenderContextManager;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.FieldHandlersManager;
import org.jbpm.formModeler.core.processing.FormProcessor;
import org.jbpm.formModeler.core.processing.formProcessing.FormChangeResponse;
import org.jbpm.formModeler.core.processing.formProcessing.FormProcessingContext;
import org.jbpm.formModeler.core.processing.formProcessing.FormulaReplacementManager;
import org.jbpm.formModeler.core.processing.formProcessing.FunctionsProvider;

public abstract class FormChangeProcessor {
    public static final int MAX_ELEMENTS_TO_SHOW = 20;
    private FormChangeProcessor nextProcessor;
    FormProcessingContext context;
    protected String[] supportedFormModes;
    protected String[] sizeRestrictedFormModes;
    @Inject
    protected FieldHandlersManager fieldHandlersManager;
    @Inject
    protected FormProcessor formProcessor;
    @Inject
    protected FormulaReplacementManager replacementManager;
    @Inject
    protected FunctionsProvider functionsProvider;
    @Inject
    FormRenderContextManager formRenderContextManager;

    public FormChangeProcessor getNextProcessor() {
        return this.nextProcessor;
    }

    public void setNextProcessor(FormChangeProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    public FormChangeResponse process(Form form, String namespace, FormChangeResponse response) {
        return this.process(FormProcessingContext.fullProcessingContext(form, namespace, null), response);
    }

    public FormChangeResponse process(Form form, String namespace, String formMode, FormChangeResponse response) {
        return this.process(FormProcessingContext.fullProcessingContext(form, namespace, formMode), response);
    }

    public FormChangeResponse process(FormProcessingContext context, FormChangeResponse response) {
        if (this.canProcess(context)) {
            this.context = context;
            response = this.doProcess(response);
        }
        if (this.nextProcessor != null) {
            response = this.nextProcessor.process(context, response);
        }
        return response;
    }

    public abstract FormChangeResponse doProcess(FormChangeResponse var1);

    public abstract int getSupportedContextType();

    public boolean canProcess(FormProcessingContext context) {
        if (this.formRenderContextManager.getRootContext(context.getNamespace()) == null) {
            return false;
        }
        if (!context.isFull() && context.getType() != this.getSupportedContextType()) {
            return false;
        }
        if (StringUtils.isEmpty((String)context.getFormMode()) || this.getSupportedFormModes() == null || this.getSupportedFormModes().length == 0) {
            return true;
        }
        return Arrays.asList(this.getSupportedFormModes()).contains(context.getFormMode());
    }

    public String[] getSupportedFormModes() {
        return this.supportedFormModes;
    }

    public void setSupportedFormModes(String[] supportedFormModes) {
        this.supportedFormModes = supportedFormModes;
    }

    public boolean restrictCombosSize(String formMode) {
        if (StringUtils.isEmpty((String)formMode) || this.getSizeRestrictedFormModes() == null || this.getSizeRestrictedFormModes().length == 0) {
            return false;
        }
        return Arrays.asList(this.getSizeRestrictedFormModes()).contains(formMode);
    }

    public String[] getSizeRestrictedFormModes() {
        return this.sizeRestrictedFormModes;
    }

    public void setSizeRestrictedFormModes(String[] sizeRestrictedFormModes) {
        this.sizeRestrictedFormModes = sizeRestrictedFormModes;
    }

    public int getMaxElementsToShow(Object[] items, String formMode) {
        return this.getMaxElementsToShow(Arrays.asList(items), formMode);
    }

    public int getMaxElementsToShow(Collection items, String formMode) {
        if (items == null) {
            return 0;
        }
        if (!this.restrictCombosSize(formMode)) {
            return items.size();
        }
        return items.size() < 20 ? items.size() : 20;
    }

    protected Collection getEvaluableFields() {
        Collection fields = this.getContextEvaluableFields();
        if (CollectionUtils.isEmpty((Collection)fields)) {
            fields = this.context.getForm().getFieldNames();
        }
        return fields;
    }

    protected Collection getContextEvaluableFields() {
        switch (this.getSupportedContextType()) {
            case 1: {
                return this.context.getFieldsToEvaluateFormula();
            }
            case 2: {
                return this.context.getFieldsToEvaluateRange();
            }
            case 3: {
                return this.context.getFieldsToEvaluateStyle();
            }
        }
        return null;
    }
}

