/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.formProcessing;

import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.logging.Log;
import org.jbpm.formModeler.core.config.FormManager;
import org.jbpm.formModeler.service.LocaleManager;

@ApplicationScoped
public class Functions {
    @Inject
    private Log log;
    @Inject
    private FormManager formManager;
    private static int[] PESO_DIGITOS_CCC = new int[]{1, 2, 4, 8, 5, 10, 9, 7, 3, 6};
    private static String[] MONTHS = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    public static final StringUtils String = new StringUtils();
    public static final WordUtils Word = new WordUtils();

    public boolean checkNIF(String dni) {
        if (StringUtils.isBlank((String)dni)) {
            return false;
        }
        String _dni = dni.toUpperCase();
        char[] letter = new char[]{'T', 'R', 'W', 'A', 'G', 'M', 'Y', 'F', 'P', 'D', 'X', 'B', 'N', 'J', 'Z', 'S', 'Q', 'V', 'H', 'L', 'C', 'K', 'E'};
        char[] nif = new char[9];
        boolean startsWithLetter = false;
        if (_dni.length() < 8 || _dni.length() > 9) {
            return false;
        }
        nif = _dni.length() == 9 ? _dni.toCharArray() : new String("0" + _dni).toCharArray();
        if (!Character.isLetter(nif[8])) {
            return false;
        }
        if (nif[0] == 'K' || nif[0] == 'L' || nif[0] == 'M' || nif[0] == 'X' || nif[0] == 'Y' || nif[0] == 'Z') {
            startsWithLetter = true;
        } else if (!Character.isDigit(nif[0])) {
            return false;
        }
        for (int i = 1; i < 8; ++i) {
            if (Character.isDigit(nif[i])) continue;
            return false;
        }
        String nifValue = startsWithLetter ? _dni.substring(1, _dni.length() - 1) : _dni.substring(0, _dni.length() - 1);
        int control = Integer.parseInt(nifValue) % 23;
        return nif[8] == letter[control];
    }

    public boolean checkIBAN(String numIBAN) {
        int digito;
        int x;
        int DC1 = 0;
        int DC2 = 0;
        if (numIBAN.length() != 24) {
            return false;
        }
        String idBancoOficina = numIBAN.substring(4, 12);
        String numCuenta = numIBAN.substring(14, 24);
        String CControl = numIBAN.substring(12, 14);
        String IBAN = numIBAN.substring(0, 4).toUpperCase();
        if (!(idBancoOficina.matches("[0-9]{8}") && numCuenta.matches("[0-9]{10}") && CControl.matches("[0-9]{2}") && IBAN.matches("ES([0-9]{2})"))) {
            return false;
        }
        for (x = 7; x >= 0; --x) {
            digito = new Integer(idBancoOficina.substring(x, x + 1));
            DC1 += PESO_DIGITOS_CCC[x + 2] * digito;
        }
        if ((DC1 = 11 - DC1 % 11) == 10) {
            DC1 = 1;
        }
        if (DC1 == 11) {
            DC1 = 0;
        }
        for (x = 9; x >= 0; --x) {
            digito = new Integer(numCuenta.substring(x, x + 1));
            DC2 += PESO_DIGITOS_CCC[x] * digito;
        }
        if ((DC2 = 11 - DC2 % 11) == 10) {
            DC2 = 1;
        }
        if (DC2 == 11) {
            DC2 = 0;
        }
        if (!CControl.equals(new Integer(DC1).toString() + new Integer(DC2).toString())) {
            return false;
        }
        String numeroIban = IBAN.replaceAll("E", "14");
        numeroIban = numeroIban.replaceAll("S", "28");
        String calcIban = idBancoOficina + CControl + numCuenta + numeroIban;
        BigInteger result = new BigInteger(calcIban).mod(new BigInteger("97"));
        return result.compareTo(new BigInteger("1")) == 0;
    }

    public boolean checkCCC(String CCC) {
        int digito;
        int x;
        int DC1 = 0;
        int DC2 = 0;
        if (CCC.length() != 20) {
            return false;
        }
        String idBancoOficina = CCC.substring(0, 8);
        String numCuenta = CCC.substring(10, 20);
        String CControl = CCC.substring(8, 10);
        if (!(idBancoOficina.matches("[0-9]{8}") && numCuenta.matches("[0-9]{10}") && CControl.matches("[0-9]{2}"))) {
            return false;
        }
        for (x = 7; x >= 0; --x) {
            digito = new Integer(idBancoOficina.substring(x, x + 1));
            DC1 += PESO_DIGITOS_CCC[x + 2] * digito;
        }
        if ((DC1 = 11 - DC1 % 11) == 10) {
            DC1 = 1;
        }
        if (DC1 == 11) {
            DC1 = 0;
        }
        for (x = 9; x >= 0; --x) {
            digito = new Integer(numCuenta.substring(x, x + 1));
            DC2 += PESO_DIGITOS_CCC[x] * digito;
        }
        if ((DC2 = 11 - DC2 % 11) == 10) {
            DC2 = 1;
        }
        if (DC2 == 11) {
            DC2 = 0;
        }
        return CControl.equals(new Integer(DC1).toString() + new Integer(DC2).toString());
    }

    public boolean checkCIF(String CIF) {
        if (CIF == null) {
            return true;
        }
        CIF = CIF.toUpperCase();
        Pattern cifPattern = Pattern.compile("[[A-H][J-N][P-S]UVW][0-9]{7}[0-9A-J]");
        if (!cifPattern.matcher(CIF).matches()) {
            return false;
        }
        int parA = 0;
        for (int i = 2; i < 8; i += 2) {
            int digito = Character.digit(CIF.charAt(i), 10);
            if (digito < 0) {
                return false;
            }
            parA += digito;
        }
        int nonB = 0;
        for (int i = 1; i < 9; i += 2) {
            int digito = Character.digit(CIF.charAt(i), 10);
            if (digito < 0) {
                return false;
            }
            int nn = 2 * digito;
            if (nn > 9) {
                nn = 1 + (nn - 10);
            }
            nonB += nn;
        }
        int parcialC = parA + nonB;
        int digitoE = parcialC % 10;
        int digitoD = digitoE > 0 ? 10 - digitoE : 0;
        char letraIni = CIF.charAt(0);
        char caracterFin = CIF.charAt(8);
        String CONTROL_SOLO_NUMEROS = "ABEH";
        String CONTROL_SOLO_LETRAS = "KPQS";
        String CONTROL_NUMERO_A_LETRA = "JABCDEFGHI";
        boolean letterOk = CONTROL_SOLO_NUMEROS.indexOf(letraIni) < 0 && CONTROL_NUMERO_A_LETRA.charAt(digitoD) == caracterFin;
        boolean digitOk = CONTROL_SOLO_LETRAS.indexOf(letraIni) < 0 && digitoD == Character.digit(caracterFin, 10);
        return letterOk || digitOk;
    }

    public int yearsOld(Date birthDate) throws ParseException {
        GregorianCalendar bd = new GregorianCalendar();
        bd.clear();
        bd.setTime(birthDate);
        GregorianCalendar td = new GregorianCalendar();
        td.clear();
        td.setTime(new Date());
        int i = -1;
        while (td.after(bd)) {
            ++i;
            bd.add(1, 1);
        }
        return i;
    }

    public Map getYearsBetween(int min, int max) throws Exception {
        if (max < min) {
            throw new Exception("Error getting years bewtween " + min + " - " + max + ".");
        }
        TreeMap<String, String> years = new TreeMap<String, String>();
        int year = new GregorianCalendar().get(1);
        for (int i = year + min; i <= year + max; ++i) {
            String value = java.lang.String.valueOf(i);
            years.put(value, value);
        }
        return years;
    }

    public Map getMonths() {
        TreeMap<String, String> months = new TreeMap<String, String>();
        ResourceBundle bundle = ResourceBundle.getBundle("org.jbpm.formModeler.core.processing.formProcessing.messages", LocaleManager.currentLocale());
        for (int i = 0; i < MONTHS.length; ++i) {
            String key = java.lang.String.valueOf(i);
            if (key.length() == 1) {
                key = "0" + key;
            }
            months.put(key, bundle.getString("months." + MONTHS[i]));
        }
        return months;
    }

    public Map getValidDays() {
        return this.getValidDays(null);
    }

    public Map getValidDays(String value) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.set(5, 1);
        if (value == null || value.equals("") || value.startsWith("/")) {
            gc.set(2, 0);
        } else if (value.endsWith("/")) {
            int month = Integer.decode(value.substring(0, value.indexOf("/")));
            gc.set(2, month);
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("MM/yyyy");
            try {
                gc.setTime(sdf.parse(value));
                gc.set(2, gc.get(2) + 1);
            }
            catch (Exception e) {
                this.log.warn((Object)("Error parsing date " + value + " : "), (Throwable)e);
            }
        }
        TreeMap<String, String> days = new TreeMap<String, String>();
        int month = gc.get(2);
        while (gc.get(2) == month) {
            int intValue = gc.get(5);
            String key = java.lang.String.valueOf(intValue);
            if (key.length() == 1) {
                key = "0" + key;
            }
            days.put(key, key);
            gc.set(5, intValue + 1);
        }
        return days;
    }

    public Map getValidDays(String sMonth, String sYear) {
        int month = Integer.decode(sMonth);
        int year = Integer.decode(sYear);
        GregorianCalendar gc = new GregorianCalendar(year, month, 1);
        HashMap<Integer, String> days = new HashMap<Integer, String>();
        while (gc.get(2) == month) {
            Integer value = new Integer(gc.get(5));
            days.put(value, value.toString());
            gc.set(5, value + 1);
        }
        return days;
    }

    public Date getDateFromFields(String sDay, String sMonth, String sYear) {
        int day = Integer.decode(sDay);
        int month = Integer.decode(sMonth);
        int year = Integer.decode(sYear);
        GregorianCalendar gc = new GregorianCalendar(year, month, day);
        return gc.getTime();
    }

    public String str() {
        return "";
    }

    public String str(String s) {
        return s;
    }

    public String semaphor(Number value, Number low, Number high) {
        if (value.doubleValue() < low.doubleValue()) {
            return "green";
        }
        if (value.doubleValue() > high.doubleValue()) {
            return "red";
        }
        return "orange";
    }
}

