/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers;

import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.fieldHandlers.DefaultFieldHandlerFormatter;
import org.jbpm.formModeler.core.processing.fieldHandlers.FieldHandlerParametersReader;
import org.jbpm.formModeler.core.wrappers.Link;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormatterException;

@Named(value="LinkFieldHandlerFormatter")
public class LinkFieldHandlerFormatter
extends DefaultFieldHandlerFormatter {
    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws FormatterException {
        FieldHandlerParametersReader paramsReader = new FieldHandlerParametersReader(httpServletRequest);
        Field field = paramsReader.getCurrentField();
        Form form = paramsReader.getCurrentForm();
        Object value = paramsReader.getCurrentFieldValue();
        String fieldName = paramsReader.getCurrentFieldName();
        int position = paramsReader.getCurrentPosition();
        String namespace = paramsReader.getCurrentNamespace();
        boolean wrong = paramsReader.isWrongField();
        String inputValue = paramsReader.getInputValue();
        Boolean isDisabled = paramsReader.isFieldDisabled();
        Boolean isReadonly = paramsReader.isFieldReadonly();
        if (value != null) {
            if (((Link)value).getLink() == null) {
                ((Link)value).setLink("");
            }
            if (((Link)value).getName() == null) {
                ((Link)value).setName("");
            }
        } else {
            value = new Link("", "");
        }
        this.setDefaultAttributes(field, form, namespace);
        this.setAttribute("value", value);
        this.setAttribute("wrong", wrong);
        this.setAttribute("inputValue", inputValue);
        this.setAttribute("position", position);
        this.setAttribute("name", fieldName);
        this.setAttribute("lang", this.getLang());
        this.setAttribute("uid", this.getFormManager().getUniqueIdentifier(form, namespace, field, fieldName));
        if (isDisabled.booleanValue()) {
            this.setAttribute("disabled", isDisabled);
        }
        if (isReadonly.booleanValue()) {
            this.setAttribute("readonly", isReadonly);
        }
        this.renderFragment("output");
    }
}

