/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.ArrayUtils;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.api.model.wrappers.I18nSet;
import org.jbpm.formModeler.core.FieldHandlersManager;
import org.jbpm.formModeler.core.processing.FieldHandler;
import org.jbpm.formModeler.core.processing.FormNamespaceData;
import org.jbpm.formModeler.core.processing.FormProcessingServices;
import org.jbpm.formModeler.core.processing.FormProcessor;
import org.jbpm.formModeler.core.processing.FormStatusData;
import org.jbpm.formModeler.core.processing.fieldHandlers.CreateDynamicObjectFieldHandler;
import org.jbpm.formModeler.core.processing.formProcessing.NamespaceManager;
import org.jbpm.formModeler.core.processing.formStatus.FormStatus;
import org.jbpm.formModeler.core.processing.formStatus.FormStatusManager;
import org.jbpm.formModeler.core.rendering.SubformFinderService;
import org.jbpm.formModeler.service.annotation.config.Config;
import org.jbpm.formModeler.service.bb.mvc.components.handling.BaseUIComponent;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Named(value="org.jbpm.formModeler.core.processing.fieldHandlers.SubFormSendHandler")
public class SubFormSendHandler
extends BaseUIComponent {
    private Logger log = LoggerFactory.getLogger(SubFormSendHandler.class);
    @Inject
    @Config(value="/formModeler/components/renderer/component.jsp")
    private String baseComponentJSP;
    @Inject
    @Config(value="/formModeler/components/renderer/show.jsp")
    private String componentIncludeJSP;
    @Inject
    private SubformFinderService subformFinderService;

    public NamespaceManager getNamespaceManager() {
        return NamespaceManager.lookup();
    }

    public FormProcessor getFormProcessor() {
        return FormProcessingServices.lookup().getFormProcessor();
    }

    public FormStatusManager getFormStatusManager() {
        return FormStatusManager.lookup();
    }

    public FieldHandlersManager getFieldHandlersManager() {
        return FormProcessingServices.lookup().getFieldHandlersManager();
    }

    public void setBaseComponentJSP(String baseComponentJSP) {
        this.baseComponentJSP = baseComponentJSP;
    }

    public void setComponentIncludeJSP(String componentIncludeJSP) {
        this.componentIncludeJSP = componentIncludeJSP;
    }

    public String getBaseComponentJSP() {
        return this.baseComponentJSP;
    }

    public String getBeanJSP() {
        return this.componentIncludeJSP;
    }

    public void actionExpandSubform(CommandRequest request) {
        this.log.debug("Expanding subform");
        Enumeration parameterNames = request.getRequestObject().getParameterNames();
        while (parameterNames.hasMoreElements()) {
            FormStatus formStatus;
            String parameterValue;
            String parameterName = (String)parameterNames.nextElement();
            if (!parameterName.endsWith(".expand") || !"true".equals(parameterValue = request.getParameter(parameterName)) && !"false".equals(parameterValue)) continue;
            boolean expand = Boolean.valueOf(parameterValue);
            FormNamespaceData fsd = this.getNamespaceManager().getNamespace(parameterName);
            HashSet<String> expandedFields = (HashSet<String>)this.getFormProcessor().getAttribute(fsd.getForm(), fsd.getNamespace(), "-jbpm-expandedFields");
            if (expandedFields == null) {
                expandedFields = new HashSet<String>();
            }
            if (expand) {
                expandedFields.add(fsd.getFieldNameInParent().substring(0, fsd.getFieldNameInParent().length() - ".expand".length()));
            } else {
                expandedFields.remove(fsd.getFieldNameInParent().substring(0, fsd.getFieldNameInParent().length() - ".expand".length()));
            }
            this.getFormProcessor().setAttribute(fsd.getForm(), fsd.getNamespace(), "-jbpm-expandedFields", expandedFields);
            this.getFormProcessor().setValues(fsd.getForm(), fsd.getNamespace(), request.getRequestObject().getParameterMap(), request.getFilesByParamName());
            String fieldName = fsd.getFieldNameInParent();
            fieldName = fieldName.substring(0, fieldName.length() - ".create".length());
            if (expand && (formStatus = this.getFormStatusManager().getFormStatus(fsd.getForm(), fsd.getNamespace())) != null) {
                formStatus.removeWrongField(fieldName);
            }
            Field field = fsd.getForm().getField(fieldName);
            FieldHandler handler = this.getFieldHandlersManager().getHandler(field.getFieldType());
            if (handler instanceof CreateDynamicObjectFieldHandler) {
                CreateDynamicObjectFieldHandler fHandler = (CreateDynamicObjectFieldHandler)handler;
                Form createForm = fHandler.getCreateForm(field, fsd.getNamespace());
                String createFormNamespace = fsd.getNamespace() + "-" + fsd.getForm().getId() + "-" + fieldName + "." + "create";
                this.getFormProcessor().clear(createForm, createFormNamespace);
                this.log.debug("Cleared subform status");
            } else {
                this.log.error("Can't clear subform to unknown field type: " + handler.getClass().getName());
            }
            this.getFormProcessor().clearFieldErrors(fsd.getForm(), fsd.getNamespace());
            break;
        }
    }

    public void actionAddItem(CommandRequest request) {
        this.log.debug("Adding item to subform");
        Set s = this.getFormNamespaceDatas(request, ".create");
        for (FormNamespaceData formData : s) {
            String fieldName = formData.getFieldNameInParent();
            fieldName = fieldName.substring(0, fieldName.length() - ".create".length());
            Field field = formData.getForm().getField(fieldName);
            FieldHandler handler = this.getFieldHandlersManager().getHandler(field.getFieldType());
            if (handler instanceof CreateDynamicObjectFieldHandler) {
                CreateDynamicObjectFieldHandler fHandler = (CreateDynamicObjectFieldHandler)handler;
                Form createForm = fHandler.getCreateForm(field, formData.getNamespace());
                String createFormNamespace = formData.getNamespace() + "-" + formData.getForm().getId() + "-" + fieldName;
                this.getFormProcessor().setAttribute(createForm, createFormNamespace, "-jbpm-doTheItemAdd", (Object)Boolean.TRUE);
                this.getFormProcessor().setValues(formData.getForm(), formData.getNamespace(), request.getRequestObject().getParameterMap(), request.getFilesByParamName());
                FormStatusData createStatus = this.getFormProcessor().read(createForm, createFormNamespace + "." + "create");
                boolean operationSuccess = createStatus.isValid();
                if (operationSuccess) {
                    this.getFormProcessor().clearFieldErrors(formData.getForm(), formData.getNamespace());
                    this.getFormProcessor().clear(createForm, createFormNamespace + "." + "create");
                } else {
                    List wrongFields = createStatus.getWrongFields();
                    this.getFormProcessor().clearFieldErrors(formData.getForm(), formData.getNamespace());
                    for (int i = 0; i < wrongFields.size(); ++i) {
                        String fieldNameToMarkAsWrong = (String)wrongFields.get(i);
                        this.getFormProcessor().forceWrongField(createForm, createFormNamespace + "." + "create", fieldNameToMarkAsWrong);
                    }
                }
                this.getFormProcessor().setAttribute(createForm, createFormNamespace, "-jbpm-doTheItemAdd", (Object)Boolean.FALSE);
                this.log.debug("Item added to subform");
                continue;
            }
            this.log.error("Can't add item to unknown field type: " + handler.getClass().getName());
        }
    }

    public void actionDeleteItem(CommandRequest request) throws Exception {
        String[] uids = request.getRequestObject().getParameterValues("child_uid_value");
        String uid = "";
        if (uids != null) {
            for (int i = 0; i < uids.length; ++i) {
                if (uids[i] == null || "".equals(uids[i])) continue;
                uid = uids[i];
            }
        }
        String sIndex = request.getParameter(uid + "_index");
        String parentFormId = request.getParameter(uid + "_parentFormId");
        String parentNamespace = request.getParameter(uid + "_parentNamespace");
        String fieldName = request.getParameter(uid + "_field");
        Form parentForm = this.subformFinderService.getFormById(Long.decode(parentFormId).longValue(), parentNamespace);
        this.getFormProcessor().setValues(parentForm, parentNamespace, request.getRequestObject().getParameterMap(), request.getFilesByParamName());
        Field field = parentForm.getField(fieldName);
        FieldHandler handler = this.getFieldHandlersManager().getHandler(field.getFieldType());
        if (handler instanceof CreateDynamicObjectFieldHandler) {
            CreateDynamicObjectFieldHandler fHandler = (CreateDynamicObjectFieldHandler)handler;
            int index = Integer.decode(sIndex);
            Object deletedResultValue = fHandler.deleteElementInPosition(parentForm, parentNamespace, fieldName, index);
            ArrayList<Integer> removedValues = (ArrayList<Integer>)this.getFormProcessor().getAttribute(parentForm, parentNamespace, "-jbpm-removed-array-elements");
            if (removedValues == null) {
                removedValues = new ArrayList<Integer>();
                this.getFormProcessor().setAttribute(parentForm, parentNamespace, "-jbpm-removed-array-elements", removedValues);
            }
            removedValues.add(index);
            this.getFormProcessor().modify(parentForm, parentNamespace, fieldName, deletedResultValue);
        } else {
            this.log.error("Cannot delete value in a field which is not a CreateDynamicObjectFieldHandler.");
        }
        this.getFormProcessor().clearFieldErrors(parentForm, parentNamespace);
    }

    public void actionEditItem(CommandRequest request) throws Exception {
        this.editItem(request, true);
    }

    public void actionSaveEditedItem(CommandRequest request) {
        this.log.debug("Saving edited item in subform");
        Set s = this.getFormNamespaceDatas(request, ".saveEdited");
        for (FormNamespaceData formData : s) {
            this.getFormProcessor().setValues(formData.getForm(), formData.getNamespace(), request.getRequestObject().getParameterMap(), request.getFilesByParamName(), true);
        }
        this.log.debug("Item from subform, saved");
    }

    public void actionCancelEditItem(CommandRequest request) throws Exception {
        this.editItem(request, false);
    }

    public void actionPreviewItem(CommandRequest request) throws Exception {
        this.previewItem(request, true);
    }

    public void actionCancelPreviewItem(CommandRequest request) throws Exception {
        this.previewItem(request, false);
    }

    public void previewItem(CommandRequest request, boolean doIt) throws Exception {
        String[] uids = request.getRequestObject().getParameterValues("child_uid_value");
        String uid = "";
        if (uids != null) {
            for (int i = 0; i < uids.length; ++i) {
                if (uids[i] == null || "".equals(uids[i])) continue;
                uid = uids[i];
            }
        }
        String index = request.getParameter(uid + "_index");
        String parentFormId = request.getParameter(uid + "_parentFormId");
        String parentNamespace = request.getParameter(uid + "_parentNamespace");
        String field = request.getParameter(uid + "_field");
        Form form = this.subformFinderService.getFormById(Long.decode(parentFormId).longValue(), parentNamespace);
        this.getFormProcessor().setValues(form, parentNamespace, request.getRequestObject().getParameterMap(), request.getFilesByParamName());
        HashMap<String, Integer> previewFields = (HashMap<String, Integer>)this.getFormProcessor().getAttribute(form, parentNamespace, "-jbpm-previewFieldPositions");
        if (previewFields == null) {
            previewFields = new HashMap<String, Integer>();
            this.getFormProcessor().setAttribute(form, parentNamespace, "-jbpm-previewFieldPositions", previewFields);
        }
        if (doIt) {
            previewFields.put(field, Integer.decode(index));
        } else {
            previewFields.remove(field);
        }
        this.getFormProcessor().clearFieldErrors(form, parentNamespace);
    }

    public void editItem(CommandRequest request, boolean doIt) throws Exception {
        HashMap<String, Map[]> editFieldPreviousValues;
        String[] uids = request.getRequestObject().getParameterValues("child_uid_value");
        String uid = "";
        if (uids != null) {
            for (int i = 0; i < uids.length; ++i) {
                if (uids[i] == null || "".equals(uids[i])) continue;
                uid = uids[i];
            }
        }
        String index = request.getParameter(uid + "_index");
        String parentFormId = request.getParameter(uid + "_parentFormId");
        String parentNamespace = request.getParameter(uid + "_parentNamespace");
        String field = request.getParameter(uid + "_field");
        Form form = this.subformFinderService.getFormById(Long.decode(parentFormId).longValue(), parentNamespace);
        this.getFormProcessor().setValues(form, parentNamespace, request.getRequestObject().getParameterMap(), request.getFilesByParamName());
        HashMap<String, Integer> editFields = (HashMap<String, Integer>)this.getFormProcessor().getAttribute(form, parentNamespace, "-jbpm-editFieldPositions");
        if (editFields == null) {
            editFields = new HashMap<String, Integer>();
            this.getFormProcessor().setAttribute(form, parentNamespace, "-jbpm-editFieldPositions", editFields);
        }
        if ((editFieldPreviousValues = (HashMap<String, Map[]>)this.getFormProcessor().getAttribute(form, parentNamespace, "-jbpm-editFieldPreviousValue")) == null) {
            editFieldPreviousValues = new HashMap<String, Map[]>();
            this.getFormProcessor().setAttribute(form, parentNamespace, "-jbpm-editFieldPreviousValue", editFieldPreviousValues);
        }
        if (doIt) {
            Field fieldToErase = form.getField(field);
            FormStatusData fsd = this.getFormProcessor().read(form, parentNamespace);
            Map[] previousValue = this.deepCloneOfMapArray((Map[])fsd.getCurrentValue(field), new HashMap());
            editFieldPreviousValues.put(field, previousValue);
            CreateDynamicObjectFieldHandler fieldHandler = (CreateDynamicObjectFieldHandler)this.getFieldHandlersManager().getHandler(fieldToErase.getFieldType());
            Form formToEdit = fieldHandler.getEditForm(fieldToErase, parentNamespace);
            this.getFormProcessor().clear(formToEdit, parentNamespace + "-" + parentFormId + "-" + field + "." + index);
            this.getFormProcessor().clear(formToEdit, parentNamespace + "-" + parentFormId + "-" + field);
            editFields.put(field, Integer.decode(index));
        } else {
            Object previousValue = editFieldPreviousValues.get(field);
            this.getFormProcessor().modify(form, parentNamespace, field, previousValue);
            editFields.remove(field);
        }
        this.getFormProcessor().clearFieldErrors(form, parentNamespace);
    }

    protected Map[] deepCloneOfMapArray(Map[] maparray, Map cache) {
        if (maparray == null || maparray.length == 0) {
            return maparray;
        }
        Object[] clone = new Map[]{};
        for (int i = 0; i < maparray.length; ++i) {
            Map map = maparray[i];
            Map cloneMap = this.deepCloneOfMap(map, cache);
            clone = (Map[])ArrayUtils.add((Object[])clone, (Object)cloneMap);
        }
        return clone;
    }

    protected Map deepCloneOfMap(Map map, Map cache) {
        if (map == null) {
            return null;
        }
        if (map instanceof I18nSet) {
            return map;
        }
        HashMap clone = new HashMap();
        Set keys = map.keySet();
        for (Object key : keys) {
            Object value = map.get(key);
            if (value == null) {
                clone.put(key, value);
                continue;
            }
            if (value instanceof Map) {
                clone.put(key, this.deepCloneOfMap((Map)value, cache));
                continue;
            }
            if (value instanceof Map[]) {
                clone.put(key, this.deepCloneOfMapArray((Map[])value, cache));
                continue;
            }
            clone.put(key, value);
        }
        return clone;
    }

    protected Set getFormNamespaceDatas(CommandRequest request, String action) {
        HashSet<FormNamespaceData> s = new HashSet<FormNamespaceData>();
        Enumeration en = request.getRequestObject().getParameterNames();
        while (en.hasMoreElements()) {
            FormNamespaceData fsd;
            String paramName = (String)en.nextElement();
            String paramValue = request.getParameter(paramName);
            if (!"true".equals(paramValue) || !paramName.endsWith(action) || (fsd = this.getNamespaceManager().getNamespace(paramName)) == null) continue;
            s.add(fsd);
        }
        return s;
    }

    public void doStart(CommandRequest request) {
    }
}

