/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.formProcessing;

import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.FieldHandler;
import org.jbpm.formModeler.core.processing.FormStatusData;
import org.jbpm.formModeler.core.processing.formProcessing.BasicFormChangeProcessor;
import org.jbpm.formModeler.core.processing.formProcessing.FormChangeResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DefaultFormulaProcessor
extends BasicFormChangeProcessor {
    private static transient Logger log = LoggerFactory.getLogger(DefaultFormulaProcessor.class);

    @Override
    public FormChangeResponse doProcess(FormChangeResponse response) {
        try {
            Form form = this.context.getForm();
            if (form == null) {
                log.warn("Form object is not present in current FormProcessingContext, formula evaluation will be canceled. context: " + this.context);
                return response;
            }
            Object loadedObject = null;
            FormStatusData statusData = this.formProcessor.read(form, this.context.getNamespace());
            Collection fieldNames = this.getEvaluableFields();
            this.evaluatedFields.clear();
            for (String fieldName : fieldNames) {
                Field field = form.getField(fieldName);
                this.evaluateFormulaForField(form, this.context.getNamespace(), field, loadedObject, statusData, response, new Date());
            }
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
        }
        return null;
    }

    @Override
    protected void evaluateFormulaForField(Form form, String namespace, Field field, Object loadedObject, FormStatusData statusData, FormChangeResponse response, Date date) {
        this.evaluatedFields.add(field.getFieldName());
        String defaultFormula = field.getDefaultValueFormula();
        if (defaultFormula != null && defaultFormula.startsWith("=")) {
            Object value = this.evaluateFormula(form, namespace, defaultFormula.substring(1), loadedObject, statusData, response, field, date);
            FormStatusData status1 = this.formProcessor.read(form, namespace);
            Object currentFieldValue = status1.getCurrentValue(field.getFieldName());
            if (currentFieldValue != null && value == null || value != null && !value.equals(currentFieldValue)) {
                FieldHandler fieldHandler = this.fieldHandlersManager.getHandler(field.getFieldType());
                Map fieldValuesMap = fieldHandler.getParamValue(namespace + "-" + form.getId() + "-" + field.getFieldName(), value, field.getFieldPattern());
                this.formProcessor.setValues(form, namespace, fieldValuesMap, fieldValuesMap, true);
            }
        }
    }

    @Override
    public int getSupportedContextType() {
        return 4;
    }
}

