/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.components.renderer;

import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.jbpm.formModeler.api.client.FormRenderContext;
import org.jbpm.formModeler.api.client.FormRenderContextManager;
import org.jbpm.formModeler.api.client.FormRenderContextTO;
import org.jbpm.formModeler.api.events.FormSubmitFailEvent;
import org.jbpm.formModeler.api.events.FormSubmittedEvent;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.FormProcessor;
import org.jbpm.formModeler.core.processing.FormStatusData;
import org.jbpm.formModeler.service.annotation.config.Config;
import org.jbpm.formModeler.service.bb.mvc.components.handling.BaseUIComponent;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandRequest;
import org.jbpm.formModeler.service.cdi.CDIBeanLocator;

@SessionScoped
@Named(value="frc")
public class FormRenderingComponent
extends BaseUIComponent {
    @Inject
    @Config(value="/formModeler/components/renderer/component.jsp")
    private String baseComponentJSP;
    @Inject
    @Config(value="/formModeler/components/renderer/show.jsp")
    private String componentIncludeJSP;
    @Inject
    private FormRenderContextManager formRenderContextManager;
    @Inject
    private FormProcessor formProcessor;
    private FormRenderContext ctx;

    public void doStart(CommandRequest commandRequest) {
        String ctxUID = commandRequest.getRequestObject().getParameter("ctxUID");
        if (StringUtils.isEmpty((String)ctxUID)) {
            return;
        }
        this.ctx = this.formRenderContextManager.getFormRenderContext(ctxUID);
    }

    public void actionSubmitForm(CommandRequest request) {
        String ctxUID = request.getRequestObject().getParameter("ctxUID");
        String persist = request.getRequestObject().getParameter("persistForm");
        FormRenderContext ctx = this.formRenderContextManager.getFormRenderContext(ctxUID);
        if (ctx == null) {
            return;
        }
        try {
            Form form = ctx.getForm();
            this.formProcessor.setValues(form, ctxUID, request.getRequestObject().getParameterMap(), request.getFilesByParamName());
            FormStatusData fsd = this.formProcessor.read(ctxUID);
            ctx.setErrors(fsd.getWrongFields().size());
            if (fsd.isValid()) {
                ctx.setSubmit(true);
                if (Boolean.parseBoolean(persist)) {
                    this.formRenderContextManager.persistContext(ctx);
                }
            }
            this.formRenderContextManager.fireContextSubmit(new FormSubmittedEvent(new FormRenderContextTO(ctx)));
        }
        catch (Exception e) {
            this.formRenderContextManager.fireContextSubmitError(new FormSubmitFailEvent(new FormRenderContextTO(ctx), e.getMessage()));
        }
    }

    public String getCtxUID() {
        return this.ctx.getUID();
    }

    public Form getForm() {
        return this.ctx.getForm();
    }

    public boolean isReadonly() {
        return this.ctx.isReadonly();
    }

    public void setBaseComponentJSP(String baseComponentJSP) {
        this.baseComponentJSP = baseComponentJSP;
    }

    public void setComponentIncludeJSP(String componentIncludeJSP) {
        this.componentIncludeJSP = componentIncludeJSP;
    }

    public String getBaseComponentJSP() {
        return this.baseComponentJSP;
    }

    public String getBeanJSP() {
        return this.componentIncludeJSP;
    }

    public FormProcessor getFormProcessor() {
        return this.formProcessor;
    }

    public void setFormProcessor(FormProcessor formProcessor) {
        this.formProcessor = formProcessor;
    }

    public static FormRenderingComponent lookup() {
        return (FormRenderingComponent)((Object)CDIBeanLocator.getBeanByType(FormRenderingComponent.class));
    }

    public boolean isSubmited() {
        return this.ctx.isSubmit();
    }
}

