/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers;

import java.text.DecimalFormat;
import java.util.Locale;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.fieldHandlers.DefaultFieldHandlerFormatter;
import org.jbpm.formModeler.core.processing.fieldHandlers.FieldHandlerParametersReader;
import org.jbpm.formModeler.service.LocaleManager;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormatterException;

@ApplicationScoped
@Named(value="SimpleFieldHandlerFormatter")
public class SimpleFieldHandlerFormatter
extends DefaultFieldHandlerFormatter {
    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws FormatterException {
        FieldHandlerParametersReader paramsReader = new FieldHandlerParametersReader(httpServletRequest);
        Field field = paramsReader.getCurrentField();
        Form form = paramsReader.getCurrentForm();
        Object value = paramsReader.getCurrentFieldValue();
        String fieldName = paramsReader.getCurrentFieldName();
        int position = paramsReader.getCurrentPosition();
        String namespace = paramsReader.getCurrentNamespace();
        boolean wrong = paramsReader.isWrongField();
        String inputValue = paramsReader.getInputValue();
        Boolean isReadonly = paramsReader.isFieldReadonly();
        this.setDefaultAttributes(field, form, namespace);
        value = this.applyPattern(field, value);
        this.setAttribute("localeManager", this.getLocaleManager());
        this.setAttribute("value", value);
        this.setAttribute("wrong", wrong);
        this.setAttribute("inputValue", inputValue);
        this.setAttribute("formId", form != null ? form.getId() : null);
        this.setAttribute("formNamespace", namespace);
        this.setAttribute("position", position);
        this.setAttribute("name", fieldName);
        this.setAttribute("formFieldName", field != null ? field.getFieldName() : null);
        this.setAttribute("lang", this.getLang());
        this.setAttribute("isEditMode", paramsReader.isEditingForm());
        this.setAttribute("uid", this.getFormManager().getUniqueIdentifier(form, namespace, field, fieldName));
        if (isReadonly.booleanValue()) {
            this.setAttribute("readonly", isReadonly);
        }
        this.renderFragment("output");
    }

    protected Object applyPattern(Field field, Object value) {
        String pattern;
        if (value instanceof Double) {
            pattern = field.getPattern();
            if (pattern == null || "".equals(pattern)) {
                pattern = field.getFieldType().getPattern();
            }
            if (pattern != null && !"".equals(value)) {
                DecimalFormat nf = (DecimalFormat)DecimalFormat.getInstance(new Locale(LocaleManager.currentLang()));
                nf.applyPattern(pattern);
                return nf.format((Double)value);
            }
        }
        if (value instanceof Double[]) {
            pattern = field.getPattern();
            if (pattern == null || "".equals(pattern)) {
                pattern = field.getFieldType().getPattern();
            }
            if (pattern != null) {
                DecimalFormat nf = (DecimalFormat)DecimalFormat.getInstance(new Locale(LocaleManager.currentLang()));
                nf.applyPattern(pattern);
                Double[] values = (Double[])value;
                Object[] _res = new Object[values.length];
                for (int i = 0; i < values.length; ++i) {
                    Double d = values[i];
                    if (d == null) continue;
                    _res[i] = nf.format(d);
                }
                return _res;
            }
        }
        return value;
    }
}

