/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.formRendering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.inject.Inject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.FieldHandler;
import org.jbpm.formModeler.core.processing.FormProcessingServices;
import org.jbpm.formModeler.core.processing.FormStatusData;
import org.jbpm.formModeler.core.processing.fieldHandlers.SubformFieldHandler;
import org.jbpm.formModeler.core.processing.formRendering.FieldI18nResourceObtainer;
import org.jbpm.formModeler.service.LocaleManager;
import org.jbpm.formModeler.service.cdi.CDIBeanLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormErrorMessageBuilder {
    private Logger log = LoggerFactory.getLogger(FormErrorMessageBuilder.class);
    @Inject
    protected FieldI18nResourceObtainer fieldI18nResourceObtainer;
    @Inject
    protected LocaleManager localeManager;

    public List getWrongFormErrors(String namespace, Form form) {
        return this.getWrongFormErrors(namespace, form, new ArrayList<String>());
    }

    public List getWrongFormErrors(String namespace, Form form, List<String> errors) {
        FormErrorMessageBuilder formErrorMessageBuilder = this;
        ResourceBundle bundle = ResourceBundle.getBundle("org.jbpm.formModeler.core.processing.formRendering.messages", formErrorMessageBuilder.localeManager.currentLocale());
        String requiredMessage = bundle.getString("errorMessages.required");
        if (namespace != null && form != null) {
            try {
                FormStatusData statusData = FormProcessingServices.lookup().getFormProcessor().read(form, namespace);
                for (int i = 0; i < statusData.getWrongFields().size(); ++i) {
                    Field field = form.getField((String)statusData.getWrongFields().get(i));
                    FieldHandler fieldHanlder = (FieldHandler)CDIBeanLocator.getBeanByNameOrType((String)field.getFieldType().getManagerClass());
                    boolean isSubform = fieldHanlder instanceof SubformFieldHandler;
                    Boolean fieldIsRequired = field.getFieldRequired();
                    boolean fieldRequired = fieldIsRequired != null && fieldIsRequired != false && !"display".equals(fieldIsRequired);
                    String currentNamespace = namespace + "-" + form.getId().intValue() + "-" + field.getFieldName();
                    String currentValue = statusData.getCurrentInputValue(currentNamespace);
                    if (isSubform) {
                        ((SubformFieldHandler)fieldHanlder).addWrongChildFieldErrors(currentNamespace, field, errors);
                        continue;
                    }
                    if (!statusData.hasErrorMessage(field.getFieldName())) {
                        if (fieldRequired && StringUtils.isEmpty((String)currentValue)) {
                            if (errors.contains(requiredMessage)) continue;
                            errors.add(0, requiredMessage);
                            continue;
                        }
                        String error = this.fieldI18nResourceObtainer.getFieldErrorMessage(field);
                        this.addErrorMessage(this.getErrorMessage(error, field, bundle), errors);
                        continue;
                    }
                    this.addErrorMessages(statusData.getErrorMessages(field.getFieldName()), field, bundle, errors);
                }
            }
            catch (Exception e) {
                this.log.error("Error getting error messages for form " + form.getId() + ": ", (Throwable)e);
            }
        }
        return errors;
    }

    protected void addErrorMessages(List msgs, Field field, ResourceBundle bundle, List<String> errors) {
        if (CollectionUtils.isEmpty((Collection)msgs)) {
            return;
        }
        for (Object msg : msgs) {
            String error = this.getErrorMessage((String)msg, field, bundle);
            this.addErrorMessage(error, errors);
        }
    }

    protected void addErrorMessage(String error, List<String> errors) {
        if (!StringUtils.isEmpty((String)error) && !errors.contains(error)) {
            errors.add(error);
        }
    }

    protected String getErrorMessage(String msg, Field field, ResourceBundle bundle) {
        if (StringUtils.isEmpty((String)msg)) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        String label = StringUtils.defaultString((String)this.fieldI18nResourceObtainer.getFieldLabel(field), (String)field.getFieldName());
        result.append(bundle.getString("error.start")).append(label).append(bundle.getString("error.end")).append(msg);
        return result.toString();
    }
}

