/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.formProcessing;

import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.jbpm.formModeler.core.processing.formProcessing.FormChangeInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetListValuesInstruction
extends FormChangeInstruction {
    private static transient Logger log = LoggerFactory.getLogger((String)SetListValuesInstruction.class.getName());
    private String XMLrepresentation;
    private String fieldName;

    public String getFieldName() {
        return this.fieldName;
    }

    public SetListValuesInstruction(String fieldName, List newValues) {
        this.fieldName = fieldName;
        this.updateListValues(newValues);
    }

    public void updateListValues(List newValues) {
        StringBuffer sb = new StringBuffer();
        sb.append("<setListValues name=\"").append(StringEscapeUtils.escapeXml((String)this.fieldName)).append("\">");
        for (int i = 0; i < newValues.size(); ++i) {
            Object[] objects = (Object[])newValues.get(i);
            String id = String.valueOf(objects[0]);
            String value = String.valueOf(objects[1]);
            String selected = String.valueOf(objects[2]);
            sb.append("<option value=\"").append(StringEscapeUtils.escapeXml((String)id)).append("\" text=\"").append(StringEscapeUtils.escapeXml((String)value)).append("\"");
            if (objects[2] != null) {
                sb.append(" selected=\"").append(selected).append("\"");
            }
            sb.append("></option>");
        }
        sb.append("</setListValues>");
        this.XMLrepresentation = sb.toString();
    }

    @Override
    public String getXML() {
        return this.XMLrepresentation;
    }
}

