/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers.subform.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jbpm.formModeler.core.processing.FormNamespaceData;
import org.jbpm.formModeler.core.processing.FormProcessor;
import org.jbpm.formModeler.core.processing.formProcessing.NamespaceManager;

@Dependent
public class SubFormHelper {
    public static final String FIELD_ROOT_VALUE = "-jbpm-field-root-value";
    @Inject
    protected NamespaceManager namespaceManager;
    @Inject
    protected FormProcessor formProcessor;

    public Object getFieldRootValue(String inputName) {
        return this.getValue(inputName, FIELD_ROOT_VALUE);
    }

    public void setFieldRootValue(String inputName, Object rootValue) {
        this.setValue(inputName, rootValue, FIELD_ROOT_VALUE);
    }

    public String getExpandedField(String inputName) {
        return (String)this.getValue(inputName, "-jbpm-expandedFields");
    }

    public void setExpandedField(String inputName, String expandedField) {
        this.setValue(inputName, expandedField, "-jbpm-expandedFields");
    }

    public void clearExpandedField(String inputName) {
        this.clearValues(inputName, "-jbpm-expandedFields");
    }

    public List<Integer> getRemovedFieldPositions(String inputName) {
        return (List)this.getValue(inputName, "-jbpm-removed-array-elements");
    }

    public void setRemovedFieldPositions(String inputName, List<Integer> positions) {
        this.setValue(inputName, positions, "-jbpm-removed-array-elements");
    }

    public void clearRemovedFieldPositions(String inputName) {
        this.clearValues(inputName, "-jbpm-removed-array-elements");
    }

    public Integer getPreviewFieldPosition(String inputName) {
        return (Integer)this.getValue(inputName, "-jbpm-previewFieldPositions");
    }

    public void setPreviewFieldPosition(String inputName, Integer position) {
        this.setValue(inputName, position, "-jbpm-previewFieldPositions");
    }

    public void clearPreviewFieldPositions(String inputName) {
        this.clearValues(inputName, "-jbpm-previewFieldPositions");
    }

    public Integer getEditFieldPosition(String inputName) {
        return (Integer)this.getValue(inputName, "-jbpm-editFieldPositions");
    }

    public void setEditFieldPosition(String inputName, Integer position) {
        this.setValue(inputName, position, "-jbpm-editFieldPositions");
    }

    public void clearEditFieldPositions(String inputName) {
        this.clearValues(inputName, "-jbpm-editFieldPositions");
    }

    public Object getEditFieldPreviousValues(String inputName) {
        return this.getValue(inputName, "-jbpm-editFieldPreviousValue");
    }

    public void setEditFieldPreviousValues(String inputName, Object values) {
        this.setValue(inputName, values, "-jbpm-editFieldPreviousValue");
    }

    public void clearEditFieldPreviousValues(String inputName) {
        this.clearValues(inputName, "-jbpm-editFieldPreviousValue");
    }

    public Object getValue(String inputName, String attribute) {
        Map values;
        FormNamespaceData rootNamespaceData = this.getRootNamespaceData(inputName);
        if (rootNamespaceData != null && (values = (Map)this.formProcessor.getAttribute(rootNamespaceData.getForm(), rootNamespaceData.getNamespace(), attribute)) != null) {
            return values.get(inputName);
        }
        return null;
    }

    protected void setValue(String inputName, Object value, String attribute) {
        FormNamespaceData rootNamespaceData = this.getRootNamespaceData(inputName);
        if (rootNamespaceData != null) {
            HashMap<String, Object> values = (HashMap<String, Object>)this.formProcessor.getAttribute(rootNamespaceData.getForm(), rootNamespaceData.getNamespace(), attribute);
            if (values == null) {
                values = new HashMap<String, Object>();
                this.formProcessor.setAttribute(rootNamespaceData.getForm(), rootNamespaceData.getNamespace(), attribute, values);
            }
            values.put(inputName, value);
        }
    }

    protected void clearValues(String inputName, String attribute) {
        Map values;
        FormNamespaceData rootNamespaceData = this.getRootNamespaceData(inputName);
        if (rootNamespaceData != null && (values = (Map)this.formProcessor.getAttribute(rootNamespaceData.getForm(), rootNamespaceData.getNamespace(), attribute)) != null) {
            Iterator it = values.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (!key.startsWith(inputName)) continue;
                it.remove();
            }
        }
    }

    protected FormNamespaceData getRootNamespaceData(String inputName) {
        FormNamespaceData rootNamespaceData = this.namespaceManager.getRootNamespace(inputName);
        if (rootNamespaceData != null) {
            return rootNamespaceData;
        }
        return this.namespaceManager.getNamespace(this.namespaceManager.getParentNamespace(inputName));
    }
}

