/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers.multipleSubform;

import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.fieldHandlers.DefaultFieldHandlerFormatter;
import org.jbpm.formModeler.core.processing.fieldHandlers.FieldHandlerParametersReader;
import org.jbpm.formModeler.core.processing.fieldHandlers.multipleSubform.CreateDynamicObjectFieldHandler;
import org.jbpm.formModeler.core.processing.fieldHandlers.subform.utils.SubFormHelper;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormatterException;

@Named(value="MultipleSubformCreateItemFormatter")
public class MultipleSubformCreateItemFormatter
extends DefaultFieldHandlerFormatter {
    @Inject
    protected SubFormHelper helper;

    public void service(HttpServletRequest request, HttpServletResponse response) throws FormatterException {
        FieldHandlerParametersReader paramsReader = new FieldHandlerParametersReader(request);
        Field field = paramsReader.getCurrentField();
        String currentNamespace = paramsReader.getCurrentNamespace();
        String fieldNS = paramsReader.getCurrentFieldName();
        String renderMode = paramsReader.getCurrentRenderMode();
        boolean isReadonly = paramsReader.isFieldReadonly();
        CreateDynamicObjectFieldHandler fieldHandler = (CreateDynamicObjectFieldHandler)this.getFieldHandlersManager().getHandler(field.getFieldType());
        Form enterDataForm = fieldHandler.getCreateForm(field, currentNamespace);
        boolean disableCreateNew = Boolean.TRUE.equals(field.getHideCreateItem());
        if (enterDataForm != null && !disableCreateNew) {
            this.setAttribute("form", enterDataForm);
            this.setAttribute("namespace", fieldNS + "." + "create");
            this.setAttribute("uid", this.namespaceManager.squashInputName(fieldNS));
            this.setAttribute("name", fieldNS);
            this.setAttribute("entityName", "");
            boolean expanded = false;
            if (Boolean.TRUE.equals(field.getHideContent())) {
                expanded = true;
                this.setAttribute("noCancelButton", true);
            } else {
                expanded = fieldNS.equals(this.helper.getExpandedField(fieldNS));
            }
            this.setAttribute("expanded", expanded);
            String newItemButtonText = field.getNewItemText().getValue(this.getLocaleManager().getCurrentLang());
            if (StringUtils.isEmpty((CharSequence)newItemButtonText)) {
                newItemButtonText = "Create";
            }
            this.setAttribute("newItemButtonText", newItemButtonText);
            String addItemButtonText = field.getAddItemText().getValue(this.getLocaleManager().getCurrentLang());
            if (StringUtils.isEmpty((CharSequence)addItemButtonText)) {
                addItemButtonText = "Add new item";
            }
            this.setAttribute("addItemButtonText", addItemButtonText);
            String cancelButtonText = field.getCancelItemText().getValue(this.getLocaleManager().getCurrentLang());
            if (StringUtils.isEmpty((CharSequence)cancelButtonText)) {
                cancelButtonText = "Cancel";
            }
            this.setAttribute("cancelButtonText", cancelButtonText);
            if (isReadonly) {
                this.setAttribute("readonly", isReadonly);
            }
            this.setAttribute("renderMode", renderMode);
            this.renderFragment("output");
        }
    }
}

