/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing;

import org.apache.commons.lang3.StringUtils;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.FieldType;
import org.jbpm.formModeler.core.FieldHandlersManager;
import org.jbpm.formModeler.core.FormCoreServices;
import org.jbpm.formModeler.core.config.FieldTypeManager;
import org.jbpm.formModeler.core.config.FormManager;
import org.jbpm.formModeler.core.processing.AbstractFieldHandler;
import org.jbpm.formModeler.core.processing.FormProcessingServices;
import org.jbpm.formModeler.core.processing.FormProcessor;
import org.jbpm.formModeler.core.processing.formProcessing.FormulaReplacementManager;
import org.jbpm.formModeler.core.processing.formProcessing.FunctionsProvider;
import org.jbpm.formModeler.core.processing.formProcessing.NamespaceManager;
import org.jbpm.formModeler.core.processing.formStatus.FormStatusManager;

public abstract class DefaultFieldHandler
extends AbstractFieldHandler {
    public String getFieldPattern(Field field) {
        if (StringUtils.isEmpty((CharSequence)field.getBag())) {
            return field.getFieldPattern();
        }
        if (!StringUtils.isEmpty((CharSequence)field.getPattern())) {
            return field.getPattern();
        }
        FieldType bagtype = this.getFieldTypeManager().getTypeByClass(field.getBag());
        if (bagtype != null) {
            return bagtype.getPattern();
        }
        return "";
    }

    public FormulaReplacementManager getReplacementManager() {
        return FormulaReplacementManager.lookup();
    }

    public FunctionsProvider getFunctionsProvider() {
        return FunctionsProvider.lookup();
    }

    public FormManager getFormManager() {
        return FormCoreServices.lookup().getFormManager();
    }

    public NamespaceManager getNamespaceManager() {
        return NamespaceManager.lookup();
    }

    public FormProcessor getFormProcessor() {
        return FormProcessingServices.lookup().getFormProcessor();
    }

    public FormStatusManager getFormStatusManager() {
        return FormStatusManager.lookup();
    }

    public FieldHandlersManager getFieldHandlersManager() {
        return FormProcessingServices.lookup().getFieldHandlersManager();
    }

    public FieldTypeManager getFieldTypeManager() {
        return FormCoreServices.lookup().getFieldTypeManager();
    }
}

