/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers;

import java.text.SimpleDateFormat;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.FieldType;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.FieldHandlersManager;
import org.jbpm.formModeler.core.processing.FormProcessingServices;
import org.jbpm.formModeler.core.processing.fieldHandlers.DateFieldHandler;
import org.jbpm.formModeler.core.processing.fieldHandlers.DefaultFieldHandlerFormatter;
import org.jbpm.formModeler.core.processing.fieldHandlers.FieldHandlerParametersReader;
import org.jbpm.formModeler.service.LocaleManager;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormatterException;

@ApplicationScoped
@Named(value="DateFieldHandlerFormatter")
public class DateFieldHandlerFormatter
extends DefaultFieldHandlerFormatter {
    public void service(HttpServletRequest request, HttpServletResponse response) throws FormatterException {
        DateFieldHandler dateFieldHandler;
        FieldHandlerParametersReader paramsReader = new FieldHandlerParametersReader(request);
        Field field = paramsReader.getCurrentField();
        Form form = paramsReader.getCurrentForm();
        String namespace = paramsReader.getCurrentNamespace();
        Object value = paramsReader.getCurrentFieldValue();
        String fieldName = paramsReader.getCurrentFieldName();
        this.setDefaultAttributes(field, form, namespace);
        Boolean isReadonly = paramsReader.isFieldReadonly();
        if (isReadonly.booleanValue()) {
            this.setAttribute("readonly", isReadonly);
        }
        FieldHandlersManager fieldHandlersManager = FormProcessingServices.lookup().getFieldHandlersManager();
        if (StringUtils.isEmpty((CharSequence)field.getBag())) {
            dateFieldHandler = (DateFieldHandler)fieldHandlersManager.getHandler(field.getFieldType());
        } else {
            FieldType bagType = this.getFieldTypeManager().getTypeByClass(field.getBag());
            dateFieldHandler = (DateFieldHandler)fieldHandlersManager.getHandler(bagType);
        }
        String inputPattern = dateFieldHandler.getDefaultPattern();
        if (!StringUtils.isEmpty((CharSequence)dateFieldHandler.getDefaultPatterTimeSuffix())) {
            inputPattern = inputPattern + " " + dateFieldHandler.getDefaultPatterTimeSuffix();
        }
        SimpleDateFormat sdf = new SimpleDateFormat(inputPattern, LocaleManager.currentLocale());
        String dateValue = "";
        if (value != null) {
            dateValue = sdf.format(value);
        }
        this.setAttribute("uid", this.namespaceManager.squashInputName(fieldName));
        this.setAttribute("name", fieldName);
        this.setAttribute("value", dateValue);
        this.setAttribute("inputPattern", dateFieldHandler.getDefaultJQueryPattern());
        this.setAttribute("timePattern", dateFieldHandler.getDefaultPatterTimeSuffix());
        this.setAttribute("onChangeScript", field.getOnChangeScript());
        this.renderFragment("output");
    }
}

