/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers.multiple;

import java.util.Collection;
import java.util.List;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.FieldType;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.FieldHandler;
import org.jbpm.formModeler.core.processing.fieldHandlers.DefaultFieldHandlerFormatter;
import org.jbpm.formModeler.core.processing.fieldHandlers.FieldHandlerParametersReader;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormatterException;

@Named(value="MultipleInputFieldHandlerFormatter")
public class MultipleInputFieldHandlerFormatter
extends DefaultFieldHandlerFormatter {
    public static final String PARAM_MODE = "show_mode";
    public static final String MODE_SHOW = "show";
    public static final String MODE_INPUT = "input";

    public void service(HttpServletRequest request, HttpServletResponse response) throws FormatterException {
        String mode = (String)this.getParameter(PARAM_MODE);
        FieldHandlerParametersReader paramsReader = new FieldHandlerParametersReader(request);
        Field field = paramsReader.getCurrentField();
        Form form = paramsReader.getCurrentForm();
        String currentNamespace = paramsReader.getCurrentNamespace();
        Object fieldValue = paramsReader.getCurrentFieldValue();
        String fieldName = paramsReader.getCurrentFieldName();
        boolean readOnly = MODE_SHOW.equals(mode) || field.getReadonly() != false || paramsReader.isFieldReadonly() != false;
        List values = (List)fieldValue;
        FieldType bagType = this.getFieldTypeManager().getTypeByClass(field.getBag());
        if (bagType == null) {
            return;
        }
        FieldHandler handler = this.getFieldHandlersManager().getHandler(bagType);
        String uid = this.namespaceManager.squashInputName(fieldName);
        this.setAttribute("uid", uid);
        this.setAttribute("formId", form.getId());
        this.setAttribute("namespace", currentNamespace);
        this.setAttribute("fieldName", fieldName);
        this.renderFragment("outputStart");
        if (!CollectionUtils.isEmpty((Collection)values)) {
            this.renderFragment("tableStart");
            this.renderFragment("startHeader");
            if (!readOnly) {
                this.renderFragment("actionsColumn");
            }
            this.renderFragment("itemsColumn");
            this.renderFragment("endHeader");
            for (int i = 0; i < values.size(); ++i) {
                this.renderFragment("startRow");
                if (!readOnly) {
                    this.setAttribute("uid", uid);
                    this.setAttribute("fieldName", fieldName);
                    this.setAttribute("index", i);
                    this.setAttribute("readOnly", readOnly);
                    this.renderFragment("rowAction");
                }
                this.renderFragment("inputRow");
                this.setRenderingAttributes(field, fieldName + "." + i, currentNamespace, values.get(i), readOnly, paramsReader.isWrongField());
                if (readOnly) {
                    this.includePage(handler.getPageToIncludeForDisplaying());
                } else {
                    this.includePage(handler.getPageToIncludeForRendering());
                }
                this.renderFragment("endRow");
            }
            this.renderFragment("tableEnd");
        }
        this.renderFragment("beforeEnd");
        if (!readOnly) {
            this.renderFragment("startAdd");
            this.setRenderingAttributes(field, fieldName, currentNamespace, null, readOnly, paramsReader.isWrongField());
            this.includePage(handler.getPageToIncludeForRendering());
            String addItemButtonText = field.getAddItemText().getValue(this.getLocaleManager().getCurrentLang());
            if (StringUtils.isEmpty((CharSequence)addItemButtonText)) {
                addItemButtonText = "Add new item";
            }
            this.setAttribute("readOnly", readOnly);
            this.setAttribute("addItemButtonText", addItemButtonText);
            this.setAttribute("fieldName", fieldName);
            this.setAttribute("uid", uid);
            this.renderFragment("endAdd");
        }
        this.renderFragment("outputEnd");
    }

    protected void setRenderingAttributes(Field field, String fieldName, String namespace, Object value, boolean isReadOnly, boolean isWrongField) {
        this.setAttribute("_ddm_currentField", field);
        this.setAttribute("_ddm_currentValue", value);
        this.setAttribute("_ddm_currentInputValue", value != null ? value.toString() : "");
        this.setAttribute("_ddm_currentFieldIsWrong", isWrongField);
        this.setAttribute("_ddm_currentNamespace", namespace);
        this.setAttribute("_ddm_currentName", fieldName);
        this.setAttribute("_ddm_fieldIsReadonly", isReadOnly);
    }
}

