/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers.customInput;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.core.fieldTypes.CustomFieldType;
import org.jbpm.formModeler.core.processing.fieldHandlers.FieldHandlerParametersReader;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.Formatter;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormatterException;
import org.jbpm.formModeler.service.cdi.CDIBeanLocator;

@ApplicationScoped
@Named(value="CustomInputFieldHandlerFormatter")
public class CustomInputFieldHandlerFormatter
extends Formatter {
    public static final String PARAM_MODE = "mode";
    public static final String MODE_INPUT = "input";
    public static final String MODE_SHOW = "show";

    public void service(HttpServletRequest request, HttpServletResponse response) throws FormatterException {
        FieldHandlerParametersReader paramsReader = new FieldHandlerParametersReader(request);
        Field field = paramsReader.getCurrentField();
        if (StringUtils.isEmpty((CharSequence)field.getCustomFieldType())) {
            return;
        }
        CustomFieldType customFieldType = (CustomFieldType)CDIBeanLocator.getBeanByType((String)field.getCustomFieldType());
        if (customFieldType == null) {
            return;
        }
        String namespace = paramsReader.getCurrentNamespace();
        Object value = paramsReader.getCurrentFieldValue();
        String mode = (String)this.getParameter(PARAM_MODE);
        String htmlCode = null;
        if (MODE_INPUT.equals(mode)) {
            htmlCode = customFieldType.getInputHTML(value, paramsReader.getCurrentFieldName(), namespace, field.getFieldRequired().booleanValue(), field.getReadonly().booleanValue(), new String[]{field.getParam1(), field.getParam2(), field.getParam3(), field.getParam4(), field.getParam5()});
        } else if (MODE_SHOW.equals(mode)) {
            htmlCode = customFieldType.getShowHTML(value, paramsReader.getCurrentFieldName(), namespace, field.getFieldRequired().booleanValue(), field.getReadonly().booleanValue(), new String[]{field.getParam1(), field.getParam2(), field.getParam3(), field.getParam4(), field.getParam5()});
        }
        if (!StringUtils.isEmpty(htmlCode)) {
            this.setAttribute("htmlCode", htmlCode);
            this.renderFragment("output");
        }
    }
}

