/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.jbpm.formapi.server.form.FormEncodingServerFactory;
import org.jbpm.formapi.server.trans.Translator;
import org.jbpm.formapi.server.trans.TranslatorFactory;
import org.jbpm.formapi.shared.form.FormDefinitionService;
import org.jbpm.formapi.shared.task.TaskDefinitionService;
import org.jbpm.model.formapi.shared.api.FormRepresentation;
import org.jbpm.model.formapi.shared.form.FormEncodingFactory;
import org.jbpm.model.formapi.shared.form.FormRepresentationDecoder;
import org.jbpm.model.formapi.shared.form.FormRepresentationEncoder;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ExportTemplateServlet
extends HttpServlet {
    private static final long serialVersionUID = -7653438101539099368L;

    public void init(ServletConfig config) throws ServletException {
        FormEncodingFactory.register((FormRepresentationEncoder)FormEncodingServerFactory.getEncoder(), (FormRepresentationDecoder)FormEncodingServerFactory.getDecoder());
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block5: {
            String profile = req.getParameter("profile");
            try {
                if (this.notEmpty(profile) && "jbpm".equals(profile)) {
                    String packageName;
                    String uuid = req.getParameter("uuid");
                    TaskDefinitionService taskService = this.createTaskService(req);
                    FormDefinitionService formService = this.createFormService(req);
                    FormRepresentation form = formService.getFormByUUID(packageName = taskService.getContainingPackage(uuid), uuid);
                    if (this.notEmpty(form.getProcessName()) || this.notEmpty(form.getTaskId())) {
                        Translator translator = TranslatorFactory.getInstance().getTranslator("ftl");
                        URL url = translator.translateForm(form);
                        String content = IOUtils.toString((InputStream)url.openStream());
                        String templateName = "";
                        templateName = !this.notEmpty(form.getTaskId()) || "startProcess".equals(form.getTaskId()) ? form.getProcessName() : form.getTaskId();
                        if (templateName != null && !"".equals(templateName)) {
                            templateName = templateName + "-taskform.ftl";
                            templateName = URLEncoder.encode(templateName, "UTF-8");
                            formService.saveTemplate(packageName, templateName, content);
                        }
                    }
                    break block5;
                }
                throw new Exception("Profile not available for " + profile);
            }
            catch (Exception e) {
                resp.sendError(500, e.getLocalizedMessage());
            }
        }
    }

    protected TaskDefinitionService createTaskService(HttpServletRequest request) {
        return (TaskDefinitionService)WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getSession().getServletContext()).getBean("guvnorTaskService");
    }

    protected FormDefinitionService createFormService(HttpServletRequest request) {
        return (FormDefinitionService)WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getSession().getServletContext()).getBean("guvnorFormService");
    }

    private boolean notEmpty(String value) {
        return value != null && !"".equals(value) && !"null".equals(value);
    }
}

