/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.jboss.resteasy.annotations.providers.jaxb.DoNotUseJAXBProvider;
import org.jbpm.formbuilder.server.RESTBaseService;
import org.jbpm.formbuilder.server.ServiceFactory;
import org.jbpm.formbuilder.server.file.FileException;
import org.jbpm.formbuilder.server.file.FileService;
import org.jbpm.formbuilder.server.xml.FileListDTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/files")
public class RESTFileService
extends RESTBaseService {
    private FileService fileService = null;
    private boolean dynamicService = true;

    protected void setContext(ServletContext context) {
        if (this.dynamicService) {
            this.fileService = ServiceFactory.getInstance().getFileService();
        }
    }

    @POST
    @Path(value="/package/{pkgName}")
    @Consumes(value={"multipart/form-data"})
    @DoNotUseJAXBProvider
    public Response saveFile(@PathParam(value="pkgName") String packageName, @Context HttpServletRequest request) {
        this.setContext(request.getSession().getServletContext());
        if (this.isMultipart(request)) {
            ServletFileUpload upload = this.createFileUpload();
            try {
                List<?> files = this.parseFiles(request, upload);
                if (files == null || files.isEmpty()) {
                    return this.error("there should be one file at least", null);
                }
                FileItem item = (FileItem)files.iterator().next();
                byte[] content = this.readItem(item);
                String fileName = item.getName();
                String expositionUrl = this.fileService.storeFile(packageName, fileName, content);
                return Response.ok((Object)expositionUrl, (String)"text/plain").build();
            }
            catch (FileException e) {
                return this.error("Problem storing file to guvnor", e);
            }
            catch (IOException e) {
                return this.error("Problem reading input of file", e);
            }
            catch (FileUploadException e) {
                return this.error("Problem reading upload of file", (Exception)((Object)e));
            }
        }
        return this.error("Must be a multipart form data post", null);
    }

    protected boolean isMultipart(HttpServletRequest request) {
        return ServletFileUpload.isMultipartContent((HttpServletRequest)request);
    }

    protected byte[] readItem(FileItem item) throws IOException {
        return IOUtils.toByteArray((InputStream)item.getInputStream());
    }

    protected List<?> parseFiles(HttpServletRequest request, ServletFileUpload upload) throws FileUploadException {
        return upload.parseRequest(request);
    }

    protected ServletFileUpload createFileUpload() {
        int maxMemorySize = 2400000;
        File tmpDirectory = new File(System.getProperty("java.io.tmpdir"));
        DiskFileItemFactory factory = new DiskFileItemFactory(maxMemorySize, tmpDirectory);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        return upload;
    }

    @DELETE
    @Path(value="/package/{pkgName}/{fileName}")
    public Response deleteFile(@Context HttpServletRequest request, @PathParam(value="pkgName") String packageName, @PathParam(value="fileName") String fileName) {
        this.setContext(request.getSession().getServletContext());
        try {
            this.fileService.deleteFile(packageName, fileName);
            return Response.noContent().build();
        }
        catch (FileException e) {
            return this.error("Problem deleting file in guvnor", e);
        }
    }

    @GET
    @Path(value="/package/{pkgName}/")
    public Response getFiles(@Context HttpServletRequest request, @PathParam(value="pkgName") String packageName, @QueryParam(value="type") String[] fileTypes) {
        this.setContext(request.getSession().getServletContext());
        try {
            ArrayList<String> allFiles = new ArrayList<String>();
            for (String fileType : fileTypes) {
                allFiles.addAll(this.fileService.loadFilesByType(packageName, fileType));
            }
            Collections.sort(allFiles);
            FileListDTO dto = new FileListDTO(allFiles);
            return Response.ok((Object)dto, (String)"application/xml").build();
        }
        catch (FileException e) {
            return this.error("Problem loading file names", e);
        }
    }

    @GET
    @Path(value="/package/{pkgName}/{fileName}")
    public Response getFile(@Context HttpServletRequest request, @PathParam(value="pkgName") String packageName, @PathParam(value="fileName") String fileName) {
        this.setContext(request.getSession().getServletContext());
        try {
            byte[] content = this.fileService.loadFile(packageName, fileName);
            return Response.ok((Object)content, (String)"application/octet-stream").build();
        }
        catch (FileException e) {
            return this.error("Problem loading file " + fileName, e);
        }
    }

    public void setFileService(FileService fileService) {
        this.fileService = fileService;
    }

    public FileService getFileService() {
        return this.fileService;
    }

    public boolean isDynamicService() {
        return this.dynamicService;
    }

    public void setDynamicService(boolean dynamicService) {
        this.dynamicService = dynamicService;
    }
}

