/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.jboss.resteasy.annotations.providers.jaxb.DoNotUseJAXBProvider;
import org.jbpm.formapi.server.form.FormEncodingServerFactory;
import org.jbpm.formapi.server.render.Renderer;
import org.jbpm.formapi.server.render.RendererException;
import org.jbpm.formapi.server.render.RendererFactory;
import org.jbpm.formapi.server.trans.Translator;
import org.jbpm.formapi.server.trans.TranslatorException;
import org.jbpm.formapi.server.trans.TranslatorFactory;
import org.jbpm.formapi.shared.form.FormDefinitionService;
import org.jbpm.formapi.shared.form.FormServiceException;
import org.jbpm.formbuilder.server.RESTBaseService;
import org.jbpm.formbuilder.server.ServiceFactory;
import org.jbpm.formbuilder.server.xml.FormPreviewDTO;
import org.jbpm.formbuilder.server.xml.ListFormsDTO;
import org.jbpm.formbuilder.server.xml.ListFormsItemsDTO;
import org.jbpm.model.formapi.shared.api.FormItemRepresentation;
import org.jbpm.model.formapi.shared.api.FormRepresentation;
import org.jbpm.model.formapi.shared.form.FormEncodingException;
import org.jbpm.model.formapi.shared.form.FormEncodingFactory;
import org.jbpm.model.formapi.shared.form.FormRepresentationDecoder;
import org.jbpm.model.formapi.shared.form.FormRepresentationEncoder;

@Path(value="/form")
public class RESTFormService
extends RESTBaseService {
    private FormDefinitionService formService = null;
    private boolean dynamicService = true;

    public void setContext(@Context ServletContext context) {
        if (this.dynamicService) {
            this.formService = ServiceFactory.getInstance().getFormDefinitionService();
        }
    }

    public RESTFormService() {
        FormEncodingFactory.register((FormRepresentationEncoder)FormEncodingServerFactory.getEncoder(), (FormRepresentationDecoder)FormEncodingServerFactory.getDecoder());
    }

    @GET
    @Path(value="/definitions/package/{pkgName}")
    public Response getForms(@PathParam(value="pkgName") String pkgName, @Context ServletContext context) {
        this.setContext(context);
        try {
            List forms = this.formService.getForms(pkgName);
            ListFormsDTO dto = new ListFormsDTO(forms);
            return Response.ok((Object)dto, (String)"application/xml").build();
        }
        catch (FormServiceException e) {
            return this.error("Problem reading forms of package " + pkgName, (Exception)((Object)e));
        }
        catch (FormEncodingException e) {
            return this.error("Problem decoding forms of package " + pkgName, (Exception)((Object)e));
        }
    }

    @GET
    @Path(value="/definitions/package/{pkgName}/id/{formId}")
    public Response getForm(@PathParam(value="pkgName") String pkgName, @PathParam(value="formId") String formId, @Context ServletContext context) {
        this.setContext(context);
        try {
            FormRepresentation form = this.formService.getForm(pkgName, formId);
            ListFormsDTO dto = new ListFormsDTO(form);
            return Response.ok((Object)dto, (String)"application/xml").build();
        }
        catch (FormServiceException e) {
            return this.error("Problem reading form " + formId, (Exception)((Object)e));
        }
        catch (FormEncodingException e) {
            return this.error("Problem decoding form " + formId, (Exception)((Object)e));
        }
    }

    @POST
    @Path(value="/definitions/package/{pkgName}")
    @Consumes(value={"text/plain"})
    @DoNotUseJAXBProvider
    public Response saveForm(String jsonBody, @PathParam(value="pkgName") String pkgName, @Context HttpServletRequest request) {
        this.setContext(request.getSession().getServletContext());
        FormRepresentationDecoder decoder = FormEncodingFactory.getDecoder();
        try {
            FormRepresentation form = decoder.decode(jsonBody);
            String formId = this.formService.saveForm(pkgName, form);
            return Response.ok((Object)("<formId>" + formId + "</formId>"), (String)"application/xml").status(Response.Status.CREATED).build();
        }
        catch (FormEncodingException e) {
            return this.error("Problem decoding form", (Exception)((Object)e));
        }
        catch (FormServiceException e) {
            return this.error("Problem saving form", (Exception)((Object)e));
        }
    }

    @DELETE
    @Path(value="/definitions/package/{pkgName}/id/{formId}")
    public Response deleteForm(@PathParam(value="pkgName") String pkgName, @PathParam(value="formId") String formId, @Context HttpServletRequest request) {
        this.setContext(request.getSession().getServletContext());
        try {
            this.formService.deleteForm(pkgName, formId);
            return Response.ok().build();
        }
        catch (FormServiceException e) {
            return this.error("Problem deleting form " + formId, (Exception)((Object)e));
        }
    }

    @GET
    @Path(value="/items/package/{pkgName}")
    public Response getFormItems(@PathParam(value="pkgName") String pkgName, @Context ServletContext context) {
        this.setContext(context);
        try {
            Map formItems = this.formService.getFormItems(pkgName);
            ListFormsItemsDTO dto = new ListFormsItemsDTO(formItems);
            return Response.ok((Object)dto, (String)"application/xml").build();
        }
        catch (FormServiceException e) {
            return this.error("Problem getting form items of package " + pkgName, (Exception)((Object)e));
        }
        catch (FormEncodingException e) {
            return this.error("Problem decoding form items of package " + pkgName, (Exception)((Object)e));
        }
    }

    @GET
    @Path(value="/items/package/{pkgName}/id/{fItemId}")
    public Response getFormItem(@PathParam(value="pkgName") String pkgName, @PathParam(value="fItemId") String formItemId, @Context ServletContext context) {
        this.setContext(context);
        try {
            FormItemRepresentation formItem = this.formService.getFormItem(pkgName, formItemId);
            ListFormsItemsDTO dto = new ListFormsItemsDTO(formItemId, formItem);
            return Response.ok((Object)dto, (String)"application/xml").build();
        }
        catch (FormServiceException e) {
            return this.error("Problem reading form item " + formItemId, (Exception)((Object)e));
        }
        catch (FormEncodingException e) {
            return this.error("Problem decoding form item " + formItemId, (Exception)((Object)e));
        }
    }

    @POST
    @Path(value="/items/package/{pkgName}/name/{fItemName}")
    @Consumes(value={"*/*"})
    @DoNotUseJAXBProvider
    public Response saveFormItem(String jsonBody, @PathParam(value="pkgName") String pkgName, @PathParam(value="fItemName") String formItemName, @Context HttpServletRequest request) {
        this.setContext(request.getSession().getServletContext());
        FormRepresentationDecoder decoder = FormEncodingFactory.getDecoder();
        try {
            FormItemRepresentation item = decoder.decodeItem(jsonBody);
            String formItemId = this.formService.saveFormItem(pkgName, formItemName, item);
            return Response.ok((Object)("<formItemId>" + formItemId + "</formItemId>"), (String)"application/xml").status(Response.Status.CREATED).build();
        }
        catch (FormEncodingException e) {
            return this.error("Problem encoding form item", (Exception)((Object)e));
        }
        catch (FormServiceException e) {
            return this.error("Problem saving form item", (Exception)((Object)e));
        }
    }

    @DELETE
    @Path(value="/items/package/{pkgName}/name/{fItemName}")
    public Response deleteFormItem(@PathParam(value="pkgName") String pkgName, @PathParam(value="fItemName") String formItemName, @Context HttpServletRequest request) {
        this.setContext(request.getSession().getServletContext());
        try {
            this.formService.deleteFormItem(pkgName, formItemName);
            return Response.ok().build();
        }
        catch (FormServiceException e) {
            return Response.noContent().build();
        }
    }

    @POST
    @Path(value="/preview/lang/{language}")
    public Response getFormPreview(FormPreviewDTO dto, @PathParam(value="language") String language, @Context ServletContext context, @Context HttpServletRequest request) {
        this.setContext(context);
        try {
            URL url = this.createTemplate(language, dto);
            Map<String, Object> inputs = dto.getInputsAsMap();
            Renderer renderer = this.getRenderer(language);
            inputs.put(Renderer.BASE_CONTEXT_PATH, context.getContextPath());
            Locale locale = request.getLocale();
            inputs.put(Renderer.BASE_LOCALE, locale == null ? "default" : locale.getDisplayName(locale));
            Object html = renderer.render(url, inputs);
            String htmlUrl = this.createHtmlTemplate(html, language, context);
            return Response.ok((Object)htmlUrl, (String)"text/plain").build();
        }
        catch (FormEncodingException e) {
            return this.error("Problem encoding form preview", (Exception)((Object)e));
        }
        catch (TranslatorException e) {
            return this.error("Problem transforming form preview to " + language + " language", (Exception)((Object)e));
        }
        catch (RendererException e) {
            return this.error("Problem rendering form preview in " + language + " language", (Exception)((Object)e));
        }
        catch (IOException e) {
            return this.error("Problem writing form preview in " + language + " language", e);
        }
    }

    @POST
    @Path(value="/template/lang/{language}")
    public Response getFormTemplate(FormPreviewDTO dto, @PathParam(value="language") String language, @Context ServletContext context) {
        this.setContext(context);
        try {
            URL url = this.createTemplate(language, dto);
            String fileName = url.getFile();
            return Response.ok((Object)("<fileName>" + fileName + "</fileName>"), (String)"application/xml").build();
        }
        catch (FormEncodingException e) {
            return this.error("Problem encoding form for templating", (Exception)((Object)e));
        }
        catch (TranslatorException e) {
            return this.error("Problem transforming form to " + language + " language", (Exception)((Object)e));
        }
    }

    @POST
    @Path(value="/template/file/{action}")
    public void processFormTemplate(@PathParam(value="action") String action, @Context ServletContext context, @Context HttpServletRequest request, @Context HttpServletResponse response) {
        try {
            String queryString;
            request.setAttribute("org.jbpm.formbuilder.server.REST.processFormTemplate.action", (Object)action);
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                int maxMemorySize = 240000;
                File tmpDirectory = new File(System.getProperty("java.io.tmpdir"));
                DiskFileItemFactory factory = new DiskFileItemFactory(maxMemorySize, tmpDirectory);
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
                List files = upload.parseRequest(request);
                for (Object obj : files) {
                    FileItem item = (FileItem)obj;
                    request.setAttribute(item.getFieldName(), (Object)item.getString());
                }
            }
            if ((queryString = request.getQueryString()) == null) {
                queryString = "?";
            }
            if (!queryString.startsWith("?")) {
                queryString = "?" + queryString;
            }
            context.getRequestDispatcher("/fbapi/mockProcess.jsp" + queryString).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            this.error("Couldn't process form template", e);
        }
    }

    @GET
    @Path(value="/template/file/{file}.temp")
    public Response getHtmlTemplate(@PathParam(value="file") String fileName) {
        try {
            File file = new File(System.getProperty("java.io.tmpdir") + File.separator + fileName + ".temp");
            String content = FileUtils.readFileToString((File)file);
            return Response.ok((Object)content, (String)"text/html").build();
        }
        catch (IOException e) {
            return this.error("Problem reading html template for file " + fileName, e);
        }
    }

    private String createHtmlTemplate(Object html, String language, ServletContext context) throws IOException {
        String contextPath = context.getContextPath();
        File file = File.createTempFile("createHtmlTemplate", ".temp");
        FileUtils.writeStringToFile((File)file, (String)html.toString());
        String url = contextPath + "/rest/form/template/file/" + file.getName();
        return url;
    }

    private URL createTemplate(String language, FormPreviewDTO dto) throws FormEncodingException, TranslatorException {
        FormRepresentationDecoder decoder = FormEncodingFactory.getDecoder();
        String json = dto.getRepresentation();
        FormRepresentation form = decoder.decode(json);
        dto.setForm(form);
        Translator translator = this.getTranslator(language);
        URL url = translator.translateForm(form);
        return url;
    }

    @GET
    @Path(value="/template/lang/{language}")
    public Response getExportTemplate(@QueryParam(value="fileName") String fileName, @QueryParam(value="formName") String formName, @PathParam(value="language") String language, @Context ServletContext context) {
        this.setContext(context);
        File file = new File(fileName);
        String headerValue = "attachment; filename=\"" + formName + '.' + language + "\"";
        try {
            return Response.ok((Object)FileUtils.readFileToByteArray((File)file), (String)"application/octet-stream").header("Content-Disposition", (Object)headerValue).build();
        }
        catch (IOException e) {
            return Response.serverError().build();
        }
    }

    protected Translator getTranslator(String language) throws TranslatorException {
        return TranslatorFactory.getInstance().getTranslator(language);
    }

    protected Renderer getRenderer(String language) throws RendererException {
        return RendererFactory.getInstance().getRenderer(language);
    }

    public void setFormService(FormDefinitionService formService) {
        this.formService = formService;
    }

    public FormDefinitionService getFormService() {
        return this.formService;
    }

    public boolean isDynamicService() {
        return this.dynamicService;
    }

    public void setDynamicService(boolean dynamicService) {
        this.dynamicService = dynamicService;
    }
}

