/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server;

import java.util.List;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jbpm.formapi.server.form.FormEncodingServerFactory;
import org.jbpm.formapi.shared.task.TaskDefinitionService;
import org.jbpm.formapi.shared.task.TaskServiceException;
import org.jbpm.formbuilder.server.RESTBaseService;
import org.jbpm.formbuilder.server.ServiceFactory;
import org.jbpm.formbuilder.server.xml.ListTasksDTO;
import org.jbpm.model.formapi.shared.form.FormEncodingFactory;
import org.jbpm.model.formapi.shared.form.FormRepresentationDecoder;
import org.jbpm.model.formapi.shared.form.FormRepresentationEncoder;

@Path(value="/io")
public class RESTIoService
extends RESTBaseService {
    private TaskDefinitionService taskService = null;
    private boolean dynamicService = true;

    public void setContext(@Context ServletContext context) {
        if (this.dynamicService) {
            this.taskService = ServiceFactory.getInstance().getTaskDefinitionService();
        }
    }

    public RESTIoService() {
        FormEncodingFactory.register((FormRepresentationEncoder)FormEncodingServerFactory.getEncoder(), (FormRepresentationDecoder)FormEncodingServerFactory.getDecoder());
    }

    @GET
    @Path(value="/package/{pkgName}")
    public Response getIoAssociations(@QueryParam(value="q") String filter, @PathParam(value="pkgName") String pkgName, @Context ServletContext context) {
        String[] filters;
        this.setContext(context);
        String[] stringArray = filters = filter == null ? new String[]{} : filter.split(" ");
        String newFilter = filters.length == 0 ? (filter == null ? "" : filter) : "";
        for (String subFilter : filters) {
            if (subFilter.startsWith("iotype:")) continue;
            newFilter = newFilter + subFilter + " ";
        }
        if (newFilter.endsWith(" ")) {
            newFilter = newFilter.substring(0, newFilter.length() - 1);
        }
        try {
            List tasks = this.taskService.query(pkgName, newFilter);
            ListTasksDTO dto = new ListTasksDTO(tasks);
            return Response.ok((Object)dto, (String)"application/xml").build();
        }
        catch (TaskServiceException e) {
            return this.error("Problem getting io associations for package " + pkgName + " with filter " + filter, (Exception)((Object)e));
        }
    }

    @GET
    @Path(value="/package/{pkgName}/process/{procName}/task/{taskName}")
    public Response getIoAssociation(@PathParam(value="pkgName") String pkgName, @PathParam(value="procName") String procName, @PathParam(value="taskName") String taskName, @Context ServletContext context) {
        this.setContext(context);
        try {
            List tasks = this.taskService.getTasksByName(pkgName, procName, taskName);
            ListTasksDTO dto = new ListTasksDTO(tasks);
            return Response.ok((Object)dto, (String)"application/xml").build();
        }
        catch (TaskServiceException e) {
            return this.error("Problem getting io association for package " + pkgName + ", process " + procName + ", task " + taskName, (Exception)((Object)e));
        }
    }

    public void setTaskService(TaskDefinitionService taskService) {
        this.taskService = taskService;
    }

    public TaskDefinitionService getTaskService() {
        return this.taskService;
    }

    public boolean isDynamicService() {
        return this.dynamicService;
    }

    public void setDynamicService(boolean dynamicService) {
        this.dynamicService = dynamicService;
    }
}

