/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.providers.jaxb.DoNotUseJAXBProvider;
import org.jbpm.formbuilder.server.RESTBaseService;
import org.jbpm.formbuilder.server.ServiceFactory;
import org.jbpm.formbuilder.server.settings.SettingsService;
import org.jbpm.model.formapi.client.CommonGlobals;
import org.jbpm.model.formapi.client.Settings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/user")
public class RESTUserService
extends RESTBaseService {
    private SettingsService settingsService;
    private static final String[] AVAILABLE_ROLES = new String[]{"admin", "webdesigner", "functionalanalyst", "client"};

    private void init() {
        if (this.settingsService == null) {
            this.settingsService = ServiceFactory.getInstance().getSettingsService();
        }
    }

    @GET
    @Path(value="/current/roles")
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    @DoNotUseJAXBProvider
    public Response getCurrentRoles(@Context HttpServletRequest request) {
        List<String> roles = RESTUserService.getRoles(request);
        StringBuilder txtRoles = new StringBuilder();
        Iterator<String> iter = roles.iterator();
        while (iter.hasNext()) {
            txtRoles.append(iter.next());
            if (!iter.hasNext()) continue;
            txtRoles.append(",");
        }
        return Response.ok((Object)txtRoles.toString()).build();
    }

    @POST
    @Path(value="/current/logout")
    public Response logout(@Context HttpServletRequest request) {
        request.getSession().invalidate();
        return Response.ok().build();
    }

    public static List<String> getRoles(HttpServletRequest request) {
        ArrayList<String> roles = new ArrayList<String>();
        for (String role : AVAILABLE_ROLES) {
            if (!request.isUserInRole(role)) continue;
            roles.add(role);
        }
        return roles;
    }

    public static boolean hasDesignerPrivileges(HttpServletRequest request) {
        List<String> roles = RESTUserService.getRoles(request);
        return roles.contains("admin") || roles.contains("webdesigner");
    }

    @GET
    @Path(value="/current/settings")
    public Response getUserSettings(@Context HttpServletRequest request) {
        this.init();
        String userName = request.getUserPrincipal().getName();
        Settings settings = this.settingsService.getSettingsByUserId(userName);
        return Response.ok((Object)settings, (String)"application/xml").build();
    }

    @POST
    @Consumes(value={"application/xml"})
    @Path(value="/current/settings")
    public Response applySettings(Settings settings, @Context HttpServletRequest request) {
        String userName = request.getUserPrincipal().getName();
        this.init();
        this.settingsService.applySettings(settings, userName);
        CommonGlobals.getInstance().setSettings(settings);
        return Response.ok().build();
    }
}

