/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server;

import org.jbpm.formapi.shared.form.FormDefinitionService;
import org.jbpm.formapi.shared.menu.MenuService;
import org.jbpm.formapi.shared.task.TaskDefinitionService;
import org.jbpm.formbuilder.server.file.FileService;
import org.jbpm.formbuilder.server.settings.SettingsService;
import org.jbpm.model.formapi.client.CommonGlobals;
import org.jbpm.model.formapi.client.Settings;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class ServiceFactory
implements BeanFactoryAware {
    private static final ServiceFactory INSTANCE = new ServiceFactory();
    private BeanFactory beanFactory;

    public static ServiceFactory getInstance() {
        return INSTANCE;
    }

    private ServiceFactory() {
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public FormDefinitionService getFormDefinitionService() {
        return (FormDefinitionService)this.getService("FormService");
    }

    public TaskDefinitionService getTaskDefinitionService() {
        return (TaskDefinitionService)this.getService("TaskService");
    }

    public FileService getFileService() {
        return (FileService)this.getService("FileService");
    }

    public MenuService getMenuService() {
        return (MenuService)this.getService("MenuService");
    }

    public SettingsService getSettingsService() {
        return (SettingsService)this.beanFactory.getBean("SettingsService");
    }

    private Object getService(String name) {
        Settings settings = CommonGlobals.getInstance().getSettings();
        String strategy = "guvnor";
        if (settings != null) {
            strategy = settings.getEntry("storage").getValue();
        }
        System.out.println("Getting service using strategy =" + strategy);
        return this.beanFactory.getBean(strategy + name);
    }
}

