/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formbuilder.server.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.jbpm.formbuilder.server.file.FileException;
import org.jbpm.formbuilder.server.file.FileService;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSFileService
implements FileService,
InitializingBean {
    private String baseUrl;
    private String fileSeparator = System.getProperty("file.separator");

    public FSFileService() {
    }

    public FSFileService(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public String storeFile(String packageName, String fileName, byte[] content) throws FileException {
        String url = this.baseUrl + this.fileSeparator + packageName + this.fileSeparator + fileName;
        File file = new File(url);
        try {
            FileUtils.writeByteArrayToFile((File)file, (byte[])content);
        }
        catch (IOException ex) {
            throw new FileException(ex.getMessage(), ex);
        }
        return url;
    }

    @Override
    public void deleteFile(String packageName, String fileName) throws FileException {
        File file = new File(this.baseUrl + this.fileSeparator + packageName + this.fileSeparator + fileName);
        FileUtils.deleteQuietly((File)file);
    }

    public void deleteFile(String url) throws FileException {
        File file = new File(url);
        FileUtils.deleteQuietly((File)file);
    }

    @Override
    public List<String> loadFilesByType(String packageName, String fileType) throws FileException {
        File baseDir = new File(this.baseUrl + this.fileSeparator + packageName + this.fileSeparator);
        Collection listFiles = FileUtils.listFiles((File)baseDir, (String[])new String[]{fileType}, (boolean)true);
        ArrayList<String> files = new ArrayList<String>();
        for (File file : listFiles) {
            files.add(file.getAbsolutePath());
        }
        return files;
    }

    @Override
    public byte[] loadFile(String packageName, String fileName) throws FileException {
        File file = new File(this.baseUrl + this.fileSeparator + packageName + this.fileSeparator + fileName);
        try {
            return FileUtils.readFileToByteArray((File)file);
        }
        catch (IOException ex) {
            throw new FileException(ex.getMessage(), ex);
        }
    }

    public void afterPropertiesSet() throws Exception {
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }
}

